package com.artfess.cgpt.violate.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticePublicity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.violate.model.BizViolateRecordDetail;
import com.artfess.cgpt.violate.manager.BizViolateRecordDetailManager;

import java.util.List;

/**
 * 竞价违约记录明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */


@RestController
@RequestMapping("/bizViolateRecordDetail/v1/")
@Api(tags = "竞价违约记录明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizViolateRecordDetailController extends BaseController<BizViolateRecordDetailManager, BizViolateRecordDetail> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizViolateRecordDetail>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizViolateRecordDetail> queryFilter){
        PageList<BizViolateRecordDetail> result = baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizViolateRecordDetail> selectOne(@RequestParam String id){
        BizViolateRecordDetail result=baseService.get(id);
        return new CommonResult(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizViolateRecordDetail detail) {
        String message = "操作成功";
        baseService.saveOrUpdate(detail);
        return new CommonResult<>(true, message);
    }



}
