package com.artfess.cgpt.supplier.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:供应商问题管理表
 * @Author: Rong Tao
 * @Date: 2024/6/19 18:18
 */
@ApiModel(value="SupplierIssueManagement对象", description="供应商问题管理表")
@TableName("biz_supplier_issue_management")
@Data
public class SupplierIssueManagement extends BizModel<SupplierIssueManagement> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_CODE_")
    private String noticeCode;

    @ApiModelProperty(value = "立项名称")
    @TableField("NOTICE_NAME_")
    private String noticeName;

    @ApiModelProperty(value = "立项类型（1.物资，2.设备）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "供应商ID（关联组织表ID）")
    @TableField("SUPPLIER_ID_")
    private String supplierId;

    @ApiModelProperty(value = "供应商编码")
    @TableField("SUPPLIER_CODE_")
    private String supplierCode;

    @ApiModelProperty(value = "供应商名称")
    @TableField("SUPPLIER_NAME_")
    private String supplierName;

    @ApiModelProperty(value = "企业ID（关联组织表ID）")
    @TableField("ENTERPRISE_ID_")
    private String enterpriseId;

    @ApiModelProperty(value = "企业编码")
    @TableField("ENTERPRISE_CODE_")
    private String enterpriseCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("ENTERPRISE_NAME_")
    private String enterpriseName;

    @ApiModelProperty(value = "企业联系人")
    @TableField("ENTERPRISE_CONTACT_")
    private String enterpriseContact;

    @ApiModelProperty(value = "企业联系电话")
    @TableField("ENTERPRISE_CONTACT_PHONE_")
    private String enterpriseContactPhone;

    @ApiModelProperty(value = "企业联系地址")
    @TableField("ENTERPRISE_CONTACT_ADDRESS_")
    private String enterpriseContactAddress;

    @ApiModelProperty(value = "问题类别（1.投标问题，2.送货问题，3.其他）")
    @TableField("PROBLEM_CATEGORY_")
    private Integer problemCategory;

    @ApiModelProperty(value = "问题描述")
    @TableField("PROBLEM_DESCRIPTION_")
    private String problemDescription;

    @ApiModelProperty(value = "处理状态（0：未处理，1.处理中，2.已处理），默认0")
    @TableField("HANDLE_STATUS_")
    private Integer handleStatus;

    @ApiModelProperty(value = "处理情况")
    @TableField("HANDLING_SITUATION_")
    private String handlingSituation;

    @ApiModelProperty(value = "记录时间")
    @TableField("RECORD_TIME_")
    private LocalDateTime recordTime;

    @ApiModelProperty(value = "处理时间")
    @TableField("HANDLE_TIME_")
    private LocalDateTime handleTime;

    @ApiModelProperty(value = "附件集合")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "供应商问题问答记录表")
    @TableField(exist = false)
    private List<SupplierIssueManagementDetail> supplierIssueManagementDetailList;

}
