package com.artfess.cgpt.supplier.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 供应商分类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@ApiModel(value="BizSupplierType对象", description="供应商分类")
@TableName("biz_supplier_type")
@Data
public class BizSupplierType extends BaseModel<BizSupplierType> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @TableField("CODE_")
    private String code;

    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "分类级别（使用字典，1：A级，2：B级，3：C级，4：D级）")
    @TableField("LEVEL_")
    private String level;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @JsonIgnore
    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @JsonIgnore
    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @JsonIgnore
    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @JsonIgnore
    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @JsonIgnore
    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @JsonIgnore
    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @JsonIgnore
    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @JsonIgnore
    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @JsonIgnore
    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @JsonIgnore
    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @JsonIgnore
    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @JsonIgnore
    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @JsonIgnore
    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @JsonIgnore
    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "供应商分类评级标准表集合")
    @TableField(exist = false)
    private List<BizSupplierTypeEvaluation> BizSupplierTypeEvaluationLists;

}
