package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.SupplierIssueManagementDao;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementManager;
import com.artfess.cgpt.supplier.model.SupplierIssueManagement;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/6/19 19:02
 */
@Service
public class SupplierIssueManagementManagerImpl extends BaseManagerImpl<SupplierIssueManagementDao, SupplierIssueManagement> implements SupplierIssueManagementManager {

    @Autowired
    private AccessoryService accessoryService;

    @Override
    public PageList<SupplierIssueManagement> queryAllByPage(QueryFilter<SupplierIssueManagement> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<SupplierIssueManagement> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<SupplierIssueManagement> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0) {
            for(SupplierIssueManagement temp : records){
                temp.setAccessoryList(accessoryService.getAccessoryBySourceId(temp.getId()));
            }
        }

        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(SupplierIssueManagement entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            //更新，删除历史附件
            accessoryService.removeBySourceId(entity.getId());
        }

        if(BeanUtils.isNotEmpty(entity.getRecordTime())){
            entity.setRecordTime(LocalDateTime.now());
        }
        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

    }

    @Override
    public void updateHandleStatus(SupplierIssueManagement entity) {

        if(entity.getHandleStatus().equals(2)){
            entity.setHandleTime(LocalDateTime.now());
        }

        super.updateById(entity);
    }

    @Override
    public SupplierIssueManagement getDetailById(String id) {
        SupplierIssueManagement result = super.getById(id);
        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        return result;
    }

}
