package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.SupplierIssueManagementDetailDao;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementDetailManager;
import com.artfess.cgpt.supplier.manager.SupplierIssueManagementManager;
import com.artfess.cgpt.supplier.model.SupplierIssueManagement;
import com.artfess.cgpt.supplier.model.SupplierIssueManagementDetail;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/4 10:50
 */
@Service
public class SupplierIssueManagementDetailManagerImpl extends BaseManagerImpl<SupplierIssueManagementDetailDao, SupplierIssueManagementDetail> implements SupplierIssueManagementDetailManager {

    @Autowired
    private SupplierIssueManagementManager supplierIssueManager;

    @Override
    public PageList<SupplierIssueManagementDetail> queryAllByPage(QueryFilter<SupplierIssueManagementDetail> queryFilter) {
        IPage<SupplierIssueManagementDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public void saveOrUpdateEntity(SupplierIssueManagementDetail entity) {
        IGroup org = ContextUtil.getCurrentGroup();
        entity.setOrgId(org.getGroupId());
        entity.setOrgCode(org.getGroupCode());
        entity.setOrgName(org.getName());
        entity.setUserId(ContextUtil.getCurrentUserId());
        entity.setUserName(ContextUtil.getCurrentUserName());
        entity.setRecordTime(LocalDateTime.now());
        SupplierIssueManagement supplierIssue = supplierIssueManager.getById(entity.getIssueId());
        if(BeanUtils.isNotEmpty(supplierIssue)){
            if(entity.getOrgId().equals(supplierIssue.getEnterpriseId())){
                entity.setType(1);
            }else {
                entity.setType(2);
            }
        }

        super.saveOrUpdate(entity);
    }

}
