package com.artfess.cgpt.supplier.manager.impl;

import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrgSupplierType;
import com.artfess.cgpt.supplier.dao.BizSupplierOrgSupplierTypeDao;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgSupplierTypeManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应商_分类中间表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@Service
public class BizSupplierOrgSupplierTypeManagerImpl extends BaseManagerImpl<BizSupplierOrgSupplierTypeDao, BizSupplierOrgSupplierType> implements BizSupplierOrgSupplierTypeManager {
    @Resource
    private BizSupplierTypeManager bizSupplierTypeManager;

    /**
     * 根据供应商查询关联类型相关数据
     * @param supplierTypeId
     * @return
     */
    @Override
    public List<BizSupplierType> getbyEnterpriseId(String supplierTypeId) {
        QueryWrapper<BizSupplierOrgSupplierType> wrapper = new QueryWrapper<>();
        wrapper.eq("SUPPLIER_ORG_ID_",supplierTypeId);
        List<BizSupplierOrgSupplierType> supplierTypes = this.list(wrapper);

        if(null == supplierTypes || supplierTypes.isEmpty()){
            return new ArrayList<>();
        }

        List<String> typeIds = supplierTypes.stream().map(BizSupplierOrgSupplierType::getSupplierTypeId).collect(Collectors.toList());
        List<BizSupplierType> bizSupplierTypes = bizSupplierTypeManager.listByIds(typeIds);
        return bizSupplierTypes;
    }


    /**
     * 更具供应商id删除关联类型相关数据
     * @param supplierTypeId
     */
    @Override
    public void deleteByEnterpriseId(String supplierTypeId) {

        QueryWrapper<BizSupplierOrgSupplierType> wrapper = new QueryWrapper<>();
        wrapper.eq("SUPPLIER_TYPE_ID_",supplierTypeId);
        this.remove(wrapper);
    }
}
