package com.artfess.cgpt.supplier.manager.impl;


import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.dao.BizSupplierEvaluationDao;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.manager.BizSupplierEvaluationManager;
import com.artfess.cgpt.supplier.manager.SupplierEvaluationDetailManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.BizSupplierEvaluation;
import com.artfess.cgpt.supplier.model.SupplierEvaluationDetail;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 供应商评价表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@Service
public class BizSupplierEvaluationManagerImpl extends BaseManagerImpl<BizSupplierEvaluationDao, BizSupplierEvaluation> implements BizSupplierEvaluationManager {

    @Autowired
    private SupplierEvaluationDetailManager supplierEvaluationDetailManager;
    @Autowired
    private BizSupplierEnterpriseManager supplierEnterpriseManager;

    @Override
    public PageList<BizSupplierEvaluation> queryAllByPage(QueryFilter<BizSupplierEvaluation> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizSupplierEvaluation> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public BizSupplierEvaluation getDetailById(String id) {
        BizSupplierEvaluation result = super.getById(id);
        LambdaQueryWrapper<SupplierEvaluationDetail> detailQW = new LambdaQueryWrapper<>();
        detailQW.eq(SupplierEvaluationDetail::getSupplierEvaluationId,id);
        result.setDetailList(supplierEvaluationDetailManager.list(detailQW));
        return result;
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizSupplierEvaluation entity) {
        List<SupplierEvaluationDetail> detailList = entity.getDetailList();

        if(BeanUtils.isNotEmpty(entity.getId())){
            LambdaQueryWrapper<SupplierEvaluationDetail> detailQW = new LambdaQueryWrapper<>();
            detailQW.eq(SupplierEvaluationDetail::getSupplierTypeEvaluationId,entity.getId());
            supplierEvaluationDetailManager.remove(detailQW);
        }else {
            //根据准入供应商id查询今年是否已评分
            LambdaQueryWrapper<BizSupplierEvaluation> hisQW = new LambdaQueryWrapper<>();
            hisQW.eq(BizSupplierEvaluation::getAdmittedSupplierId,entity.getAdmittedSupplierId())
                    .likeRight(BizSupplierEvaluation::getScoreTime, LocalDate.now().getYear())
                    .eq(BizSupplierEvaluation::getIsDele,"0");
            int count = super.count(hisQW);
            if(count>0){
                //如果已评分
                throw new BaseException("供应商【"+entity.getSupplierName()+"】本年度已评分，请在已有记录上进行修改");
            }
        }

        entity.setScoreTime(LocalDateTime.now());

        //更新等级到准入供应商
        LambdaUpdateWrapper<BizSupplierEnterprise> supplierEnterpriseUW = new LambdaUpdateWrapper<>();
        supplierEnterpriseUW.set(BizSupplierEnterprise::getLevel,entity.getLevel())
                .eq(BizSupplierEnterprise::getId,entity.getAdmittedSupplierId())
                .eq(BizSupplierEnterprise::getIsDele,"0");
        supplierEnterpriseManager.update(supplierEnterpriseUW);

        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            detailList.stream().forEach(s->s.setSupplierEvaluationId(entity.getId()));
            supplierEvaluationDetailManager.saveBatch(detailList);
        }

    }

    @Override
    @Transactional
    public void removeById(String id) {
        super.removeById(id);

        LambdaQueryWrapper<SupplierEvaluationDetail> detailQW = new LambdaQueryWrapper<>();
        detailQW.eq(SupplierEvaluationDetail::getSupplierTypeEvaluationId,id);
        supplierEvaluationDetailManager.remove(detailQW);

    }

}
