package com.artfess.cgpt.supplier.manager.impl;


import cn.hutool.core.bean.BeanUtil;
import com.artfess.base.exception.BaseException;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.qualification.manager.BizQualificationLabelManager;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.cgpt.supplier.dao.BizSupplierEnterpriseDao;
import com.artfess.cgpt.supplier.manager.*;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.supplier.model.*;
import com.artfess.cgpt.supplier.vo.BizSupplierEnterpriseDetailVo;
import com.artfess.cgpt.supplier.vo.SupplierEnterpriseDetailVo;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.file.util.MinioUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.dao.OrgDao;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.annotation.Untainted;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 供应商_企业关联表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@Service
public class BizSupplierEnterpriseManagerImpl extends BaseManagerImpl<BizSupplierEnterpriseDao, BizSupplierEnterprise> implements BizSupplierEnterpriseManager {

    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private AdmittedSuppliersQualificationManager suppliersQualificationManager;
    @Autowired
    private SupplierEnterpriseAuditingManagerImpl supplierEnterpriseAuditingManager;
    @Autowired
    private BizSupplierOrgQualificationLabelManager supplierOrgQualificationLabelManager;
    @Autowired
    private BizQualificationLabelManager qualificationLabelManager;
    @Autowired
    private BizMaterialCategoryManager matCategoryManager;

    @Override
    public BizSupplierEnterprise getById(Serializable id) {
        return baseMapper.getById(id);
    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizSupplierEnterprise entity) {

        List<AdmittedSuppliersQualification> suppliersQualificationList = entity.getSuppliersQualificationList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();
//        List<Accessory> accessoryList = entity.getAccessoryList();

        if(BeanUtils.isEmpty(entity.getId())){
            String supplierTypeId = entity.getSupplierTypeId();

            //如果是新增
            List<Org> supplierList = entity.getSupplierList();
            if(BeanUtils.isEmpty(supplierList) || supplierList.size()<=0){
                throw new BaseException("请选择供应商！");
            }
            for(Org supplier : supplierList){
                //查询是否已有数据
                if(BeanUtils.isNotEmpty(supplierTypeId)){
                    List<String> cateIdList = Arrays.asList(supplierTypeId.split(","));
                    for(String cateId : cateIdList){
                        LambdaQueryWrapper<BizSupplierEnterprise> hisQW = new LambdaQueryWrapper<>();
                        hisQW.eq(BizSupplierEnterprise::getEnterpriseId, entity.getEnterpriseId())
                                .eq(BizSupplierEnterprise::getSupplierId, supplier.getId())
                                .like(BizSupplierEnterprise::getSupplierTypeId,cateId)
//                        .eq(BizSupplierEnterprise::getType,1)
                                .eq(BizSupplierEnterprise::getIsDele, 0);
//                        .orderByDesc(BizSupplierEnterprise::getCreateTime)
//                        .last("limit 1");
//                BizSupplierEnterprise his = baseMapper.selectOne(hisQW);
                        Integer count = baseMapper.selectCount(hisQW);
                        if(count>0){
                            BizMaterialCategory cate = matCategoryManager.getById(cateId);
                            throw new BaseException("供应商【"+supplier.getName()+"】的业务【"+cate.getName()+"】已存在");
                        }
                    }
                }


                BizSupplierEnterprise data = new BizSupplierEnterprise();

                try {
                    BeanUtils.copyNotNullProperties(data,entity);
                } catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                data.setSupplierId(supplier.getId());
                data.setSupplierCode(supplier.getCode());
                data.setSupplierName(supplier.getName());
                //如果有，更新
//                if(BeanUtils.isNotEmpty(his)){
//                    data.setId(his.getId());
//                    data.setReviewStatus(his.getReviewStatus());
//                }
                super.save(data);

                if(BeanUtils.isNotEmpty(suppliersQualificationList) && suppliersQualificationList.size()>0){
                    List<AdmittedSuppliersQualification> supQualificationDataList = new ArrayList<>();
                    for(AdmittedSuppliersQualification temp : suppliersQualificationList){
                        AdmittedSuppliersQualification supQualification = new AdmittedSuppliersQualification();
                        try {
                            BeanUtils.copyNotNullProperties(supQualification,temp);
                        } catch (ReflectiveOperationException e) {
                            e.printStackTrace();
                        }
                        supQualification.setAdmittedSupplierId(data.getId());
                        supQualificationDataList.add(supQualification);
                    }
                    suppliersQualificationManager.saveBatch(supQualificationDataList);
                }

                if(BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size()>0){
                    List<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<>();
                    for(BizQualificationLabel label : qualificationLabelList){
                        if(BeanUtils.isEmpty(label.getId())){
                            qualificationLabelManager.saveOrUpdateEntity(label);
                        }
                        BizSupplierOrgQualificationLabel temp = new BizSupplierOrgQualificationLabel();
                        temp.setAdmittedSupplierId(data.getId());
                        temp.setQualificationLabelId(label.getId());
                        supplierOrgQualificationLabelList.add(temp);
                    }
                    supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
                }

            }
        }else {
            //更新
            super.updateById(entity);
            //删除历史资质类型关联表
            LambdaQueryWrapper<AdmittedSuppliersQualification> supQualificationQW = new LambdaQueryWrapper<>();
            supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId,entity.getId());
            suppliersQualificationManager.remove(supQualificationQW);
            //删除历史资质关联信息
            LambdaQueryWrapper<BizSupplierOrgQualificationLabel> qualificationLabelQW = new LambdaQueryWrapper<>();
            qualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getAdmittedSupplierId,entity.getId());
            supplierOrgQualificationLabelManager.remove(qualificationLabelQW);

            //删除历史附件
//            accessoryService.removeBySourceId(entity.getId());

            if(BeanUtils.isNotEmpty(suppliersQualificationList) && suppliersQualificationList.size()>0){
                List<AdmittedSuppliersQualification> supQualificationDataList = new ArrayList<>();
                for(AdmittedSuppliersQualification temp : suppliersQualificationList){
                    AdmittedSuppliersQualification supQualification = new AdmittedSuppliersQualification();
                    try {
                        BeanUtils.copyNotNullProperties(supQualification,temp);
                    } catch (ReflectiveOperationException e) {
                        e.printStackTrace();
                    }
                    supQualification.setAdmittedSupplierId(entity.getId());
                    supQualificationDataList.add(supQualification);
                }
                suppliersQualificationManager.saveBatch(supQualificationDataList);

                if(BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size()>0){
                    List<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<>();
                    for(BizQualificationLabel label : qualificationLabelList){
                        if(BeanUtils.isEmpty(label.getId())){
                            qualificationLabelManager.saveOrUpdateEntity(label);
                        }
                        BizSupplierOrgQualificationLabel temp = new BizSupplierOrgQualificationLabel();
                        temp.setAdmittedSupplierId(entity.getId());
                        temp.setQualificationLabelId(label.getId());
                        supplierOrgQualificationLabelList.add(temp);
                    }
                    supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
                }

            }
        }

//        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
//            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
//            accessoryService.saveBatch(accessoryList);
//        }

    }

    @Override
    @Transactional
    public void saveOrUpdateTempSupplier(BizSupplierEnterprise entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();

        String supplierTypeId = entity.getSupplierTypeId();

        if(BeanUtils.isNotEmpty(supplierTypeId)){
            List<String> cateIdList = Arrays.asList(supplierTypeId.split(","));
            for(String cateId : cateIdList){
                //查询是否已有数据
                LambdaQueryWrapper<BizSupplierEnterprise> hisQW = new LambdaQueryWrapper<>();
                hisQW.eq(BizSupplierEnterprise::getEnterpriseId, entity.getEnterpriseId())
                        .eq(BizSupplierEnterprise::getSupplierId, entity.getSupplierId())
//                .eq(BizSupplierEnterprise::getType,2)
                        .eq(BizSupplierEnterprise::getIsDele, 0)
                        .like(BizSupplierEnterprise::getSupplierTypeId,cateId)
                        .ne(BeanUtils.isNotEmpty(entity.getId()),BizSupplierEnterprise::getId,entity.getId());

                Integer count = baseMapper.selectCount(hisQW);
                if(count>0){
                    BizMaterialCategory cate = matCategoryManager.getById(cateId);
                    throw new BaseException("供应商【"+entity.getSupplierName()+"】的业务【"+cate.getName()+"】已存在");
                }
            }

        }


        if(BeanUtils.isNotEmpty(entity.getId())){
            //更新
            //删除历史附件
            accessoryService.removeBySourceId(entity.getId());
        }
        entity.setReviewStatus(2);
        super.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }
    }

    @Override
    public PageList<BizSupplierEnterprise> queryByPage(QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        PageList<BizSupplierEnterprise> result = new PageList<>(baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass())));
        return result;
    }

    @Override
    public PageList<BizSupplierEnterprise> queryQuaByPage(QueryFilter<BizSupplierEnterprise> queryFilter) {
        queryFilter.addFilter("a.IS_DELE_","0", QueryOP.EQUAL);
        PageList<BizSupplierEnterprise> result = new PageList<>(baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter,currentModelClass())));

        List<BizSupplierEnterprise> data = result.getRows();
        if(BeanUtils.isNotEmpty(data) && data.size()>0){
            for(BizSupplierEnterprise temp : data){
                //查询资质类型关联表
                LambdaQueryWrapper<AdmittedSuppliersQualification> supQualificationQW = new LambdaQueryWrapper<>();
                supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId,temp.getId());
                temp.setSuppliersQualificationList(suppliersQualificationManager.list(supQualificationQW));
            }
        }

        return result;
    }

    @Override
    @Transactional
    public void uploadAccessory(BizSupplierEnterprise entity) {
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<BizQualificationLabel> qualificationLabelList = entity.getQualificationLabelList();

        //删除历史资质关联信息
        LambdaQueryWrapper<BizSupplierOrgQualificationLabel> qualificationLabelQW = new LambdaQueryWrapper<>();
        qualificationLabelQW.eq(BizSupplierOrgQualificationLabel::getAdmittedSupplierId,entity.getId());
        supplierOrgQualificationLabelManager.remove(qualificationLabelQW);

        //删除历史附件
        accessoryService.removeBySourceId(entity.getId());

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.stream().forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

        if(BeanUtils.isNotEmpty(qualificationLabelList) && qualificationLabelList.size()>0){
            List<BizSupplierOrgQualificationLabel> supplierOrgQualificationLabelList = new ArrayList<>();
            for(BizQualificationLabel label : qualificationLabelList){
                if(BeanUtils.isEmpty(label.getId())){
                    qualificationLabelManager.saveOrUpdateEntity(label);
                }
                BizSupplierOrgQualificationLabel temp = new BizSupplierOrgQualificationLabel();
                temp.setAdmittedSupplierId(entity.getId());
                temp.setQualificationLabelId(label.getId());
                supplierOrgQualificationLabelList.add(temp);
            }
            supplierOrgQualificationLabelManager.saveBatch(supplierOrgQualificationLabelList);
        }

        LambdaUpdateWrapper<BizSupplierEnterprise> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BizSupplierEnterprise::getReviewStatus,BeanUtils.isNotEmpty(entity.getReviewStatus())?entity.getReviewStatus():0)
                .eq(BizSupplierEnterprise::getId,entity.getId());
        super.update(updateWrapper);
    }

    @Override
    @Transactional
    public void updateReviewStatus(String id, String status) {
        List<String> idList = Arrays.asList(id.split(","));
        LambdaUpdateWrapper<BizSupplierEnterprise> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(BizSupplierEnterprise::getReviewStatus,status)
                .in(BizSupplierEnterprise::getId,idList);
        super.update(updateWrapper);
    }

    @Override
    @Transactional
    public void updateReviewStatus(String id, String status,String rejectionReason) {
        BizSupplierEnterprise data = super.getById(id);
        data.setReviewStatus(Integer.valueOf(status));
        super.updateById(data);

        if(status.equals("2") || status.equals("3")){
            //生成审核记录
            SupplierEnterpriseAuditing auditing = new SupplierEnterpriseAuditing();
            auditing.setAdmittedSupplierId(id);
            auditing.setType(data.getType());
            auditing.setReviewerId(ContextUtil.getCurrentUserId());
            auditing.setReviewerName(ContextUtil.getCurrentUserName());
            auditing.setReviewTime(LocalDateTime.now());
            if(status.equals("2")){
                auditing.setReviewResult(1);
            }else {
                auditing.setReviewResult(0);
                if(BeanUtils.isNotEmpty(rejectionReason)){
                    auditing.setRejectionReason(rejectionReason);
                }
            }
            supplierEnterpriseAuditingManager.save(auditing);
        }

    }

    @Override
    public boolean updateVo(BizSupplierEnterprise entity) {
        String supplierIds = entity.getSupplierId();
        List<String> list = Arrays.asList(supplierIds.split(","));
        String supplierCodes = entity.getSupplierCode();
        List<String> codeList = Arrays.asList(supplierCodes.split(","));


        //先把原来的删除
        boolean result = this.removeById(entity.getId());

        for (int i = 0; i < list.size(); i++) {
            String supplierId = list.get(i);
            String supplierCode = codeList.get(i);
            entity.setSupplierId(supplierId);
            entity.setSupplierCode(supplierCode);
            entity.setId(null);
            this.save(entity);
        }
        return result;
    }

    @Override
    public BizSupplierEnterprise getDetailById(String id) {
        BizSupplierEnterprise result = super.getById(id);

        //查询资质类型关联表
        LambdaQueryWrapper<AdmittedSuppliersQualification> supQualificationQW = new LambdaQueryWrapper<>();
        supQualificationQW.eq(AdmittedSuppliersQualification::getAdmittedSupplierId,id);
        result.setSuppliersQualificationList(suppliersQualificationManager.list(supQualificationQW));

        //查询关联资质库
        QueryFilter<BizSupplierOrgQualificationLabel> qualificationQF = QueryFilter.build();
        qualificationQF.setPageBean(new PageBean(0,-1,false));
        qualificationQF.addFilter("a.ADMITTED_SUPPLIER_ID_",id,QueryOP.EQUAL);
        result.setQualificationLabelList(supplierOrgQualificationLabelManager.queryQualificationPage(qualificationQF).getRows());

        //查询附件
        if(BeanUtils.isNotEmpty(result.getQualificationLabelList()) && result.getQualificationLabelList().size()>0){
            result.getQualificationLabelList().forEach(s->{
                s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
            });
        }

//        result.setAccessoryList(accessoryService.getAccessoryBySourceId(id));
        return result;
    }

}
