package com.artfess.cgpt.supplier.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.supplier.vo.BizSupplierEnterpriseDetailVo;
import com.artfess.cgpt.supplier.vo.SupplierEnterpriseDetailVo;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 供应商_企业关联表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
public interface BizSupplierEnterpriseManager extends BaseManager<BizSupplierEnterprise> {

    /**
     * 保存或更新数据
     * @param entity
     * @return
     */
    void saveOrUpdateEntity(BizSupplierEnterprise entity);

    /**
     * 保存或更新临时供应商
     * @param entity
     * @return
     */
    void saveOrUpdateTempSupplier(BizSupplierEnterprise entity);

    /**
     * 分页查询数据
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierEnterprise> queryByPage(QueryFilter<BizSupplierEnterprise> queryFilter);

    /**
     * 分页查询数据（带资质类型关联）
     * @param queryFilter
     * @return
     */
    PageList<BizSupplierEnterprise> queryQuaByPage(QueryFilter<BizSupplierEnterprise> queryFilter);

    /**
     * 上传资质附件
     * @param entity
     * @return
     */
    void uploadAccessory(BizSupplierEnterprise entity);

    /**
     * 更新审核状态
     * @param id
     * @param status
     */
    void updateReviewStatus(String id,String status);

    /**
     * 更新审核状态
     * @param id
     * @param status
     * @param rejectionReason 驳回原因
     */
    void updateReviewStatus(String id,String status,String rejectionReason);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizSupplierEnterprise getDetailById(String id);

    boolean updateVo(BizSupplierEnterprise entity);

}
