package com.artfess.cgpt.supplier.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.supplier.manager.DataSharingManager;
import com.artfess.cgpt.supplier.model.DataSharing;
import com.artfess.cgpt.supplier.model.Enterprise;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:数据共享管理
 * @Author: Rong Tao
 * @Date: 2024/8/6 19:30
 */
@RestController
@RequestMapping("/dataSharing/v1/")
@Api(tags="数据共享管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class DataSharingController extends BaseController<DataSharingManager, DataSharing> {

    @PostMapping(value="/queryAll")
    @ApiOperation("M-分页查询所有数据")
    public PageList<DataSharing> queryAll(@RequestBody QueryFilter<DataSharing> queryFilter) {
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryByPage")
    @ApiOperation("M-分页查询当前公司数据")
    public PageList<DataSharing> queryByPage(@RequestBody QueryFilter<DataSharing> queryFilter) {
        queryFilter.addFilter("ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody DataSharing entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/getDataById")
    @ApiOperation("根据id查询详情")
    public CommonResult getDataById(@RequestParam("id") String id) {
        DataSharing result = baseService.getDataById(id);
        return new CommonResult(true,"操作成功",result);
    }

    @PostMapping("/removeByIds")
    @ApiOperation("根据id查询详情")
    public CommonResult removeByIds(@RequestParam("ids") String ids) {
        baseService.removeByIds(ids);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/getBizIdsByOrg")
    @ApiOperation("根据公司查询可共享的数据id")
    public CommonResult getBizIdsByOrg(@RequestParam("orgId") String orgId) {
        List<String> result = baseService.getBizIdsByOrg(orgId);
        return new CommonResult(true,"操作成功",result);
    }

}
