package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeEvaluationManager;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierTypeEvaluation;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import com.artfess.cgpt.supplier.manager.BizSupplierTypeManager;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 供应商分类 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizSupplierType/v1/")
@Api(tags="供应商分类信息")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierTypeController extends BaseController<BizSupplierTypeManager, BizSupplierType> {

    @Autowired
    private BizSupplierTypeEvaluationManager bizSupplierTypeEvaluationManager;

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizSupplierType>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizSupplierType> queryFilter){
        PageList<BizSupplierType> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@ApiParam(name="ids",value = "id集合数组") @RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody BizSupplierType entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizSupplierType> selectOne(@ApiParam(name="id",value = "id主键") @RequestParam String id){
//        BizExpertDatabase result=baseService.getExpertById(id);
        BizSupplierType result = baseService.getById(id);
        if(result != null){
            LambdaQueryWrapper<BizSupplierTypeEvaluation> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(BizSupplierTypeEvaluation::getSupplierTypeId, id);
            List<BizSupplierTypeEvaluation> list = bizSupplierTypeEvaluationManager.list(queryWrapper);
            result.setBizSupplierTypeEvaluationLists(list);
        }
        return new CommonResult<>(true,"查询成功",result);
    }


    @GetMapping("/getNextSequence")
    @ApiOperation(value = "S-获取下一个排序号")
    public CommonResult<Integer> getNextSequence(){
        Integer result = baseService.getNextSequence(new HashMap<>());
        return new CommonResult<>(true,"查询成功",result);
    }

}
