package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import com.artfess.cgpt.supplier.model.BizSupplierType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.supplier.model.BizSupplierOrgBlacklist;
import com.artfess.cgpt.supplier.manager.BizSupplierOrgBlacklistManager;

import java.util.List;

/**
 * 供应商黑名单，本表有附件 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
@RestController
@RequestMapping("/bizSupplierOrgBlacklist/v1/")
@Api(tags="供应商黑名单")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierOrgBlacklistController extends BaseController<BizSupplierOrgBlacklistManager, BizSupplierOrgBlacklist> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizSupplierOrgBlacklist>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizSupplierOrgBlacklist> queryFilter){
        PageList<BizSupplierOrgBlacklist> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizSupplierOrgBlacklist> selectOne(@RequestParam String id){
        BizSupplierOrgBlacklist result = baseService.getDataById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @RequestMapping(value = "/saveOrUpdateEntity", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveSupplierType(@RequestBody BizSupplierOrgBlacklist entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

}
