package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.supplier.manager.BizSupplierEvaluationManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.model.BizSupplierEvaluation;
import com.artfess.cgpt.supplier.model.BizSupplierOrg;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * 供应商评价评价表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@RestController
@RequestMapping("/supplier/bizSupplierEvaluation/v1/")
@Api(tags="供应商评价")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierEvaluationController extends BaseController<BizSupplierEvaluationManager, BizSupplierEvaluation> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加供应商评价的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="供应商评价信息") @RequestBody BizSupplierEvaluation entity) {
        boolean result = baseService.save(entity);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, entity.getId());
        }
        return new CommonResult<>();
    }


    @PostMapping("/saveList")
    @ApiOperation("添加供应商评价的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="供应商评价信息") @RequestBody List<BizSupplierEvaluation> entitys) {

        boolean result = baseService.saveBatch(entitys);

        return new CommonResult<>();
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新供应商评价")
    public CommonResult<String> updateById(@ApiParam(name="model", value="供应商评价信息") @RequestBody BizSupplierEvaluation entity) {
        boolean result = baseService.updateById(entity);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新供应商评价失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<BizSupplierEvaluation>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizSupplierEvaluation> queryFilter){
        PageList<BizSupplierEvaluation> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @GetMapping("getById/{id}")
    @ApiOperation("根据id查询详情")
    public BizSupplierEvaluation getDetailById(@PathVariable String id) {
        return baseService.getDetailById(id);
    }

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新数据")
    public CommonResult saveOrUpdateEntity(@RequestBody BizSupplierEvaluation entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-根据id删除")
    public CommonResult remove(@RequestParam("id") String id){
        baseService.removeById(id);
        return new CommonResult<>(true,"删除成功");
    }

}
