package com.artfess.cgpt.supplier.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.supplier.manager.BizSupplierEnterpriseManager;
import com.artfess.cgpt.supplier.model.BizSupplierEnterprise;
import com.artfess.cgpt.supplier.vo.BizSupplierEnterpriseDetailVo;
import com.artfess.cgpt.supplier.vo.SupplierEnterpriseDetailVo;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.uc.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * 供应商_企业关联表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author baseli
 * @since 2024-03-26
 */
@RestController
@RequestMapping("/supplier/bizSupplierEnterprise/v1/")
@Api(tags="准入供应商管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizSupplierEnterpriseController extends BaseController<BizSupplierEnterpriseManager, BizSupplierEnterprise> {

    @Autowired
    UCFeignService ucFeignService;

    @PostMapping("/saveOrUpdateEntity")
    @ApiOperation("保存或更新准入供应商")
    public CommonResult saveOrUpdateEntity(@RequestBody BizSupplierEnterprise entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/saveOrUpdateTempSupplier")
    @ApiOperation("保存或更新临时供应商")
    public CommonResult saveOrUpdateTempSupplier(@RequestBody BizSupplierEnterprise entity) {
        baseService.saveOrUpdateTempSupplier(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/uploadAccessory")
    @ApiOperation("上传资质附件")
    public CommonResult uploadAccessory(@RequestBody BizSupplierEnterprise entity) {
        baseService.uploadAccessory(entity);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/modifyReviewStatusById")
    @ApiOperation("根据id修改审核状态")
    public CommonResult modifyReviewStatusById(@RequestParam("id") String id,@RequestParam("status") String status) {
        baseService.updateReviewStatus(id,status);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping("/updateReviewStatus")
    @ApiOperation("更新审核状态")
    public CommonResult updateReviewStatus(@RequestParam("id") String id,@RequestParam("status") String status
            ,@RequestParam("rejectionReason") String rejectionReason) {
        baseService.updateReviewStatus(id,status,rejectionReason);
        return new CommonResult(true,"操作成功");
    }

    @PostMapping(value="/queryByEnterprise")
    @ApiOperation("分页当前企业数据")
    public PageList<BizSupplierEnterprise> queryByEnterprise(@RequestBody QueryFilter<BizSupplierEnterprise> queryFilter) {
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new PageList<>(new ArrayList<BizSupplierEnterprise>());
        }
        queryFilter.addFilter("a.ENTERPRISE_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        return baseService.queryByPage(queryFilter);
    }

    @PostMapping(value="/queryBySupplier")
    @ApiOperation("分页当前供应商数据")
    public PageList<BizSupplierEnterprise> queryBySupplier(@RequestBody QueryFilter<BizSupplierEnterprise> queryFilter) {
        if(BeanUtils.isEmpty(ContextUtil.getCurrentOrgId())){
            return new PageList<>(new ArrayList<BizSupplierEnterprise>());
        }
        queryFilter.addFilter("a.SUPPLIER_ID_", ContextUtil.getCurrentOrgId(),QueryOP.EQUAL);
        return baseService.queryQuaByPage(queryFilter);
    }

    @Override
    @PostMapping(value="/query", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询所有数据")
    public PageList<BizSupplierEnterprise> query(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<BizSupplierEnterprise> queryFilter) {
        return baseService.queryByPage(queryFilter);
    }

    @GetMapping("getById/{id}")
    @ApiOperation("根据id查询详情")
    public BizSupplierEnterprise getDetailById(@PathVariable String id) {
        return baseService.getDetailById(id);
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新供应商")
    public CommonResult<String> updateById(@ApiParam(name="model", value="供应商信息") @RequestBody BizSupplierEnterprise entity) {
        boolean result = baseService.updateVo(entity);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新供应商失败");
        }
        return new CommonResult<>();
    }

    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="供应商id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除供应商失败");
        }
        return new CommonResult<>();
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="供应商集合") @RequestParam String...ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除供应商失败");
        }
        return new CommonResult<>();
    }
}
