package com.artfess.cgpt.sso.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.sso.model.SsoSystem;

import javax.servlet.http.HttpServletRequest;

/**
 * 单点登录系统配置 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-12-02
 */
public interface SsoSystemManager extends BaseManager<SsoSystem> {

    SsoSystem getEntityByAkAndSk(String ak,String sk);

    /**
    * 新增
    * @param ssoSystem   单点登录系统配置
    * @Return: boolean
    * @Author: chens
    * @Date: 2022/12/2 16:14
    */
    boolean insertSsoSystem(SsoSystem ssoSystem) throws Exception;

    /**
     * 修改
     * @param ssoSystem   单点登录系统配置
     * @Return: boolean
     * @Author: chens
     * @Date: 2022/12/2 16:14
     */
    boolean updateSsoSystem(SsoSystem ssoSystem);

    /**
     * 根据系统编码获取系统名称
     * @param sysCode 系统编码
     * @Return: 系统名称
     */
    String getSysNameByCode(String sysCode);

    /**
     * 根据当前请求获取系统编码
     * @param request
     * @return
     */
    String getCurrentSysCode(HttpServletRequest request);

}
