package com.artfess.cgpt.receipt.model;

import com.artfess.base.entity.BizModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description:采购发货单表
 * @Author: Rong Tao
 * @Date: 2024/8/19 20:12
 */
@ApiModel(value="Arrival对象", description="采购发货单表")
@TableName("biz_arrival")
@Data
public class Arrival extends BizModel<Arrival> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "发货单号（自动生成）")
    @TableField("ARRIVAL_CODE_")
    private String arrivalCode;

    @ApiModelProperty(value = "采购订单ID")
    @TableField("PURCHASE_ORDER_ID_")
    private String purchaseOrderId;

    @ApiModelProperty(value = "采购订单号")
    @TableField("PURCHASE_ORDER_CODE_")
    private String purchaseOrderCode;

    @ApiModelProperty(value = "合同ID，关联合同表ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "不含税金额")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税金额")
    @TableField("TOTAL_AMOUNT_")
    private BigDecimal totalAmount;

    @ApiModelProperty(value = "发货人ID")
    @TableField("VENDOR_USER_ID_")
    private String vendorUserId;

    @ApiModelProperty(value = "发货人姓名")
    @TableField("VENDOR_USER_NAME_")
    private String vendorUserName;

    @ApiModelProperty(value = "发货人联系方式")
    @TableField("VENDOR_PHONE_")
    private String vendorPhone;

    @ApiModelProperty(value = "发货人所属公司ID")
    @TableField("VENDOR_ID_")
    private String vendorId;

    @ApiModelProperty(value = "发货人所属公司编码")
    @TableField("VENDOR_CODE_")
    private String vendorCode;

    @ApiModelProperty(value = "发货人所属公司名称")
    @TableField("VENDOR_NAME_")
    private String vendorName;

    @ApiModelProperty(value = "发货时间")
    @TableField("ARRIVAL_DATE_")
    private LocalDateTime arrivalDate;

    @ApiModelProperty(value = "收货地址")
    @TableField("UNLOAD_ADDRESS_")
    private String unloadAddress;

    @ApiModelProperty(value = "收货人所属公司ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "收货人所属公司编码")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "收货人所属公司名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "状态（1：未发货，2：已发货，3：已收货，4：已结算）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "明细集合")
    @TableField(exist = false)
    private List<ArrivalDetail> detailList;

}
