package com.artfess.cgpt.receipt.manager;

import com.artfess.cgpt.receipt.model.BizReconciliation;
import com.artfess.base.manager.BaseManager;
import com.artfess.cgpt.receipt.vo.BizReconciliationVo;

import java.util.List;

/**
 * 对账单表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizReconciliationManager extends BaseManager<BizReconciliation> {

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizReconciliation getDetail(String id);

    /**
     * 根据id集合删除数据
     * @param ids
     * @return
     */
    void removeByIds(List<String> ids);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveVo(BizReconciliation entity);

    /**
     * 根据id修改状态
     * @param ids
     * @param status
     */
    void updateStatus(String ids, Integer status);


    /**
     * 推送到支付平台
     * @param ids ID主键集合
     */
    void pushToZfpt(List<String> ids);

}
