package com.artfess.cgpt.receipt.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.receipt.vo.ReceiptVo;
import com.artfess.cgpt.receipt.model.BizReceipt;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 采购收货单表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
public interface BizReceiptManager extends BaseManager<BizReceipt> {

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizReceipt getDetailById(String id);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveVo(BizReceipt entity);

    /**
     * 根据id集合删除数据
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 根据id修改状态
     * @param id
     * @param status
     */
    void updateStatus(String id, Integer status);

    /**
     * 分页查询供应商分组
     * @param queryFilter
     * @return
     */
    PageList<BizReceipt> pageVendorGroup(QueryFilter<BizReceipt> queryFilter);

}
