package com.artfess.cgpt.receipt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.artfess.cgpt.utils.BizUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.receipt.model.BizReceiptHandle;
import com.artfess.cgpt.receipt.manager.BizReceiptHandleManager;

import java.util.List;

/**
 * 采购收货单处理记录表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */

@RestController
@RequestMapping("/bizReceiptHandle/v1/")
@Api(tags = "采购收货单处理记录表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReceiptHandleController extends BaseController<BizReceiptHandleManager, BizReceiptHandle> {

    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<BizReceiptHandle>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<BizReceiptHandle> queryFilter){

        queryFilter.addFilter("is_dele_", 0, QueryOP.EQUAL);

        PageList<BizReceiptHandle> result=baseService.query(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }


    @PostMapping("receipt/handlelog")
    @ApiOperation(value = "S-查询某个收货单的修改记录")
    public CommonResult<List<BizReceiptHandle>> receiptHandleLog(@RequestParam String receiptId){


        List<BizReceiptHandle> list=baseService.receiptHandleLog(receiptId);


        return new CommonResult<>(true,"查询成功",list);
    }


    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizReceiptHandle> selectOne(@RequestParam String id){
        BizReceiptHandle result=baseService.get(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizReceiptHandle entity) {
        String message = "操作成功";
        baseService.save(entity);
        return new CommonResult<>(true, message);
    }
}
