package com.artfess.cgpt.receipt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.receipt.manager.BizReceiptDetailManager;
import com.artfess.cgpt.receipt.model.BizReceiptDetail;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 采购收货单明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@RestController
@RequestMapping("/bizReceiptDetail/v1/")
@Api(tags = "采购收货单明细表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class BizReceiptDetailController extends BaseController<BizReceiptDetailManager, BizReceiptDetail> {


    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<BizReceiptDetail>> queryAllByPage(@RequestBody QueryFilter<BizReceiptDetail> queryFilter){
        PageList<BizReceiptDetail> result = baseService.queryAllPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<BizReceiptDetail> selectOne(@RequestParam String id){
        BizReceiptDetail result=baseService.getDetail(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeHandleLog(ids);

        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody BizReceiptDetail entity) {
        String message = "操作成功";
        baseService.save(entity);
        return new CommonResult<>(true, message);
    }



//    @PostMapping("/confirm")
//    @ApiOperation(value = "S-确认收货")
//    public CommonResult confirm(@RequestParam List<String> ids){
//        baseService.confirm(ids);
//        return new CommonResult<>(true,"操作成功");
//    }

}
