package com.artfess.cgpt.qualification.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDate;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 资质库表，该表需要上传附件
 *
 * @author 管理员
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-12-23
 */
@ApiModel(value = "BizQualificationLabel对象", description = "资质库表，该表需要上传附件")
@Data
@TableName("biz_qualification_label")
public class BizQualificationLabel extends BizModel<BizQualificationLabel> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "资质类型编码")
    @TableField("QUALIFICATION_TYPE_CODE_")
    private String qualificationTypeCode;

    @ApiModelProperty(value = "资质类别名称")
    @TableField("QUALIFICATION_TYPE_NAME_")
    private String qualificationTypeName;

    @ApiModelProperty(value = "资质编码（添加为空就自动生成）")
    @TableField("QUALIFICATION_CODE_")
    private String qualificationCode;

    @ApiModelProperty(value = "资质名称")
    @TableField("QUALIFICATION_NAME_")
    private String qualificationName;

    @ApiModelProperty(value = "取得日期")
    @TableField("QUALIFICATION_ACQUISITION_DATE_")
    private LocalDate qualificationAcquisitionDate;

    @ApiModelProperty(value = "到期日期")
    @TableField("EXPIRY_DATE_")
    private String expiryDate;

    @ApiModelProperty(value = "资质来源（1：企业，2：专家，3：个人）")
    @TableField("QUALIFICATION_FORM_")
    private Integer qualificationForm;

    @ApiModelProperty(value = "资质关联成员ID（包括企业，专家，个人）-单选")
    @TableField("QUALIFICATION_MEMBER_ID_")
    private String qualificationMemberId;

    @ApiModelProperty(value = "资质关联成员名称（包括企业，专家，个人）-单选")
    @TableField("QUALIFICATION_MEMBER_")
    private String qualificationMember;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "审批状态（1.草稿，2.审批中，3.已审核），默认1")
    @TableField("APPROVAL_STATUS_")
    private Integer approvalStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "附件信息")
    @TableField(exist = false)
    private List<Accessory> accessoryList;

//    @ApiModelProperty(value = "附件集合")
//    @TableField(exist = false)
//    private List<DefaultFile> fileList;

}
