package com.artfess.cgpt.qualification.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 资质库表，该表需要上传附件 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-23
 */
public interface BizQualificationLabelManager extends BaseManager<BizQualificationLabel> {

    PageList<BizQualificationLabel> queryAllByPage(QueryFilter<BizQualificationLabel> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    String saveOrUpdateEntity(BizQualificationLabel entity);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    BizQualificationLabel getDataById(String id);

    /**
     * 根据id集合删除
     * @param ids
     * @return
     */
    void removeByIds(List<String> ids);

    /**
     * 根据ID修改审核状态
     * @param id
     * @param status
     */
    void updateApprovalStatusById(String id,String status);

}
