package com.artfess.cgpt.purchasing.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/18 14:35
 */
@Data
public class PurDetailVo implements Serializable {

    @ApiModelProperty( value="单据编号")
    private String prbillCode;

    @ApiModelProperty( value="编制公司")
    private String matCompany;

    @ApiModelProperty( value="物料分类")
    private String matCategory;

    @ApiModelProperty( value="企业物料编号")
    private String matCode;

    @ApiModelProperty( value="平台物料编号")
    private String matPlatcode;

    @ApiModelProperty( value="物料名称")
    private String matName;

    @TableField("mat_material")
    @ApiModelProperty( value="物料牌号")
    @Excel(name = "物料牌号")
    private String matMaterial;

    @ApiModelProperty( value="规格型号")
    private String matSpec;

    @ApiModelProperty( value="计量单位")
    private String matUnit;

    @ApiModelProperty( value="品牌")
    private String matBrand;

    @ApiModelProperty( value="基础扩展")
    private String matBaseExt;

    @ApiModelProperty( value="其他扩展")
    private String matOtherExt;

    @ApiModelProperty( value="数量")
    private BigDecimal purQuantity;

    @ApiModelProperty( value="单价")
    private BigDecimal purPrice;

    @ApiModelProperty( value="金额")
    private BigDecimal purAmount;

    @ApiModelProperty( value="需求日期")
    private LocalDate purReqdate;

    @ApiModelProperty( value="收货地址")
    private String unloadAddress;

    @ApiModelProperty( value="采购方式")
    private String purMode;

    @ApiModelProperty( value="合同编号")
    private String contrCode;

    @ApiModelProperty( value="备注")
    private String purNote;

    @ApiModelProperty( value="税率")
    private BigDecimal taxRate;

    @ApiModelProperty( value="税额")
    private BigDecimal taxValue;

    @ApiModelProperty( value="含税单价")
    private BigDecimal taxInprice;

    @ApiModelProperty( value="含税金额")
    private BigDecimal taxInvalue;

    @ApiModelProperty( value="是否集采物料")
    private Integer matIfPlat;

    @ApiModelProperty( value="供应商编号")
    private String vendorCode;

    @ApiModelProperty( value="供应商名称")
    private String vendorName;

    @ApiModelProperty( value="供应商税号")
    private String vendorOrgcode;

    @TableField("line_num")
    @ApiModelProperty( value="行号")
    private String lineNum;

    @ApiModelProperty( value="计划编号")
    private String planCode;

}
