package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;

import java.time.LocalDate;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购申请_资质标签关联表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@ApiModel(value="BizPurchasingApplicationQualification对象", description="采购申请_资质标签关联表")
@TableName("biz_purchasing_application_qualification")
@Data
public class PurchasingApplicationQualification extends BizNoModel<PurchasingApplicationQualification> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "采购申请明细ID（关联物料采购申请明细表ID或者是关联项目采购明细ID）")
    @TableField("PURCHASING_APPLICATION_DETAILS_ID_")
    private String purchasingApplicationDetailsId;

    @ApiModelProperty(value = "资质标签ID")
    @TableField("QUALIFICATION_LABEL_ID_")
    private String qualificationLabelId;

    @ApiModelProperty(value = "资质类别编码（使用字典，字典数据待定，先创建一个叫资质类别的供前端选择）")
    @TableField("QUALIFICATION_TYPE_VALUE_")
    private Integer qualificationTypeValue;

    @ApiModelProperty(value = "资质类别名称")
    @TableField("QUALIFICATION_TYPE_NAME_")
    private String qualificationTypeName;

    @ApiModelProperty(value = "资质编码（使用系统流水号功能生成，格式：yyyyMMdd+流水号，例如：2022209280001）")
    @TableField("QUALIFICATION_CODEE_")
    private String qualificationCodee;

    @ApiModelProperty(value = "资质名称")
    @TableField("QUALIFICATION_NAME_")
    private Integer qualificationName;

    @ApiModelProperty(value = "有效截止期")
    @TableField("EXPIRY_DATE_")
    private LocalDate expiryDate;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIBE_")
    private String describe;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
