package com.artfess.cgpt.purchasing.model;

import java.math.BigDecimal;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

/**
 * 物料采购申请明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@ApiModel(value="BizPurchasingApplicationDetails对象", description="物料采购申请明细表")
@TableName("biz_purchasing_application_details")
@Data
public class PurchasingApplicationDetails extends BizNoModel<PurchasingApplicationDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "申请单编号（自动生成）")
    @TableField("APPLICATION_NUM_")
    private String applicationNum;

//    @ApiModelProperty(value = "定价方式（1：平台定价，2：合同采购，3：企业线下定价，4.单一来源采购）")
    @ApiModelProperty(value = "定价方式（1：公开招标，2：询比价，3：限时竞价，" +
        "4：份额采购（谈判），5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField("PROCUREMENT_METHOD_")
    private Integer procurementMethod;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "物料分类编号，关联物料分类CODE")
    @TableField("MAT_CATEGORY_")
    private String matCategory;

    @ApiModelProperty(value = "物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    @Excel(name = "*平台物料编号")
    private String matPlatcode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    @Excel(name = "*数量")
    private BigDecimal matNum;

    @ApiModelProperty(value = "最高限价")
    @TableField("MAXIMUM_PRICE_LIMIT_")
    @Excel(name = "最高限价(元)")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @TableField(exist = false)
    @Excel(name = "*需求日期")
    private String demandDateValue;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    @Excel(name = "*计划编号")
    private String planCode;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS")
    @Excel(name = "送货地址")
    private String unloadAddress;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("REMARKS_")
    @Excel(name = "企业补充说明")
    private String remarks;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    private Integer matIfPlat;

    @ApiModelProperty(value = "合同匹配完成状态（0.未完成，1.完成），默认0")
    @TableField("PUR_CONTRACT_STATUS_")
    private Integer purContractStatus;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "状态（1：未立项，2：已立项，3：流标，4：已签订合同），默认1")
    @TableField("STATUS_")
    private Integer status;

}
