package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * @Description:采购申请审核记录表
 * @Author: Rong Tao
 * @Date: 2024/6/13 16:12
 */
@ApiModel(value="PurchasingApplicationAuditRecords对象", description="采购申请审核记录表")
@TableName("biz_purchasing_application_audit_records")
@Data
public class PurchasingApplicationAuditRecords extends BizNoModel<PurchasingApplicationAuditRecords> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "申请表ID")
    @TableField("APPLICATION_ID_")
    private String applicationId;

    @ApiModelProperty(value = "申请单编号")
    @TableField("APPLICATION_NUM_")
    private String applicationNum;

    @ApiModelProperty(value = "状态（1：通过，2：驳回）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "审批时间")
    @TableField("AUDITING_DATE_")
    private LocalDateTime auditingDate;

    @ApiModelProperty(value = "审批人")
    @TableField("AUDITING_USER_")
    private String auditingUser;

    @ApiModelProperty(value = "驳回原因")
    @TableField("AUDITING_REASON_")
    private String auditingReason;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
