package com.artfess.cgpt.purchasing.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableName;

import java.math.BigDecimal;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;

import java.time.LocalDateTime;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 采购申请表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@ApiModel(value="BizPurchasingApplication对象", description="采购申请表")
@TableName("biz_purchasing_application")
@Data
public class PurchasingApplication extends BizModel<PurchasingApplication> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "申请类型（1：标准采购申请，2：固定单价申请，3：其他，如果选择固定单价申请，所有明细数量为1）")
    @TableField("APPLICATION_TYPE_")
    private Integer applicationType;

    @ApiModelProperty(value = "申请单编号（自动生成）")
    @TableField("APPLICATION_NUM_")
    private String applicationNum;

    @ApiModelProperty(value = "编制人ID")
    @TableField("PREPARED_USER_ID_")
    private String preparedUserId;

    @ApiModelProperty(value = "编制人姓名")
    @TableField("PREPARED_USER_NAME_")
    private String preparedUserName;

    @ApiModelProperty(value = "编制公司ID")
    @TableField("PREPARED_ORG_ID_")
    private String preparedOrgId;

    @ApiModelProperty(value = "编制公司编号")
    @TableField("PREPARED_ORG_CODE_")
    private String preparedOrgCode;

    @ApiModelProperty(value = "编制公司名称")
    @TableField("PREPARED_ORG_NAME_")
    private String preparedOrgName;

    @ApiModelProperty(value = "编制部门")
    @TableField("PUR_BZBM_")
    private String purBzbm;

    @ApiModelProperty(value = "编制日期")
    @TableField("PREPARED_DATE")
    private LocalDate preparedDate;

    @ApiModelProperty(value = "需求日期")
    @TableField("APPLICATION_DATE_")
    private LocalDate applicationDate;

    @ApiModelProperty(value = "是否集中采购（0：自采，1：集采）")
    @TableField("MAT_IF_PLAT_")
    private Integer matIfPlat;

//    @ApiModelProperty(value = "定价方式（1：平台定价，2：合同采购，3：企业线下定价，4.单一来源采购）")
    @ApiModelProperty(value = "定价方式（1：公开招标，2：询比价，3：限时竞价，" +
            "4：份额采购（谈判），5：单一来源，6：比选（多轮竞价），7：公开邀请）")
    @TableField("PROCUREMENT_METHOD_")
    private Integer procurementMethod;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private Integer hasQualification;

    @ApiModelProperty(value = "来源类型（1.手工录入，2.数据集成）")
    @TableField("APPLICATION_SOURCE_")
    private Integer applicationSource;

    @ApiModelProperty(value = "计划类型（1.月度计划，2.季度计划，3.年度计划，4.临期计划）")
    @TableField("PLAN_TYPE_")
    private Integer planType;

    @ApiModelProperty(value = "状态（1：草稿，2：审批中，3：已审批，4：已立项，5：流标，6：已发中选公示，7：已签订合同，8：驳回）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "合并状态（1.未合并，2.已合并）")
    @TableField("MERGE_STATUS_")
    private Integer mergeStatus;

    @ApiModelProperty(value = "合并父级ID")
    @TableField("MERGE_PID_")
    private String mergePid;

    @ApiModelProperty(value = "合并版本")
    @TableField("MERGE_VERSION_")
    private Integer mergeVersion;

    @ApiModelProperty(value = "付款方式（1：现金，2：承兑，3.其他）")
    @TableField("PAY_METHOD_")
    private Integer payMethod;

    @ApiModelProperty(value = "报价方式（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "合同匹配完成状态（0.未完成，1.完成），默认0")
    @TableField("PUR_CONTRACT_STATUS_")
    private Integer purContractStatus;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

//    @TableField(exist = false)
//    @ApiModelProperty(value = "采购单位")
//    private List<Org> orgList;

    @TableField(exist = false)
    @ApiModelProperty(value = "采购单位")
    private List<PurchasingUnit> unitList;

    @TableField(exist = false)
    @ApiModelProperty(value = "物料采购申请明细")
    private List<PurchasingApplicationDetails> detailsList;

    @TableField(exist = false)
    @ApiModelProperty(value = "资质标签")
    private List<PurchasingApplicationQualification> qualificationList;

    @TableField(exist = false)
    @ApiModelProperty(value = "资质附件")
    private List<Accessory> quaAccessoryList;

    @TableField(exist = false)
    @ApiModelProperty(value = "相关文件")
    private List<Accessory> accessoryList;

    @ApiModelProperty(value = "审批人")
    @TableField("AUDITING_USER_")
    private String auditingUser;

    @ApiModelProperty(value = "审批时间")
    @TableField("AUDITING_DATE_")
    private LocalDateTime auditingDate;

    @ApiModelProperty(value = "驳回原因")
    @TableField(exist = false)
    private String auditingReason;

    @ApiModelProperty(value = "是否需要发布公告（0,.否，1.是），单一来源使用")
    @TableField("IS_ANNOUNCEMENT_")
    private Integer isAnnouncement;

    @ApiModelProperty(value = "是否代采（0.否，1.是），默认0")
    @TableField("IS_AGENCY_PROCURE_")
    private Integer isAgencyProcure;

    @ApiModelProperty(value = "代采单位ID")
    @TableField("AGENCY_PROCURE_ORG_ID_")
    private String agencyProcureOrgId;

    @ApiModelProperty(value = "代采单位编码")
    @TableField("AGENCY_PROCURE_ORG_CODE_")
    private String agencyProcureOrgCode;

    @ApiModelProperty(value = "代采单位名称")
    @TableField("AGENCY_PROCURE_ORG_NAME_")
    private String agencyProcureOrgName;

}
