package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.purchasing.dao.PurchasingRulesDetailDao;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesDetailManager;
import com.artfess.cgpt.purchasing.model.PurchasingRulesDetail;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/22 14:34
 */
@Service
public class PurchasingRulesDetailManagerImpl extends BaseManagerImpl<PurchasingRulesDetailDao, PurchasingRulesDetail> implements PurchasingRulesDetailManager {

    @Override
    public PageList<PurchasingRulesDetail> queryByPage(QueryFilter<PurchasingRulesDetail> queryFilter) {
        IPage<PurchasingRulesDetail> result = baseMapper.queryByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<PurchasingRulesDetail> queryAllByPage(QueryFilter<PurchasingRulesDetail> queryFilter) {
        queryFilter.addFilter("b.IS_DELE_","0", QueryOP.EQUAL);
        IPage<PurchasingRulesDetail> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
