package com.artfess.cgpt.purchasing.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.manager.*;
import com.artfess.cgpt.bidding.model.*;
import com.artfess.cgpt.bidding.vo.EvaVo;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemDescriptionManager;
import com.artfess.cgpt.evaluation.manager.BizEvaluationSystemManager;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystem;
import com.artfess.cgpt.evaluation.model.BizEvaluationSystemDescription;
import com.artfess.cgpt.expert.model.BizExpertDatabase;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.PushNoticeVO;
import com.artfess.cgpt.foreignApi.vo.WxNoticeTemplate;
import com.artfess.cgpt.project.manager.UserParticipationManager;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.cgpt.purchasing.dao.MatApprovalDao;
import com.artfess.cgpt.purchasing.manager.*;
import com.artfess.cgpt.purchasing.model.*;
import com.artfess.cgpt.supplier.model.BizSupplierOrgBlacklist;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeDetaileManager;
import com.artfess.cgpt.winbind.manager.BizWinBiddingNoticeManager;
import com.artfess.cgpt.winbind.model.BizWinBiddingNotice;
import com.artfess.cgpt.winbind.model.BizWinBiddingNoticeDetaile;
import com.artfess.redis.util.RedisUtil;
import com.artfess.sysConfig.persistence.manager.SysDictionaryManager;
import com.artfess.sysConfig.persistence.param.DictModel;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.manager.OrgManager;
import com.artfess.uc.manager.OrgUserManager;
import com.artfess.uc.manager.UserManager;
import com.artfess.uc.model.Org;
import com.artfess.uc.model.OrgUser;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/26 9:46
 */
@Service
public class MatApprovalManagerImpl extends BaseManagerImpl<MatApprovalDao, MatApproval> implements MatApprovalManager {

    @Value("${cgpt.noticeUrl}")
    private String cgptPushNoticeUrl;
    @Value("${wxPublic.noticeTemplateId}")
    private String wxNoticeTemplateId;

    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private MatApprovalDetailsManager matApprovalDetailsManager;
    @Autowired
    private QuotationTemplateDetailApprovalManager quotationTemplateDetailApprovalManager;
    @Autowired
    private TenderDocumentManager tenderDocumentManager;
    @Autowired
    private AccessoryService accessoryService;
    @Autowired
    private ProjectEvaluationExpertManager evaluationExpertManager;
    @Autowired
    private UserParticipationManager userParticipationManager;
    @Autowired
    private BizBidOpeningManager bidOpeningManager;
    @Autowired
    private ApprovalInviteVendorManager approvalInviteVendorManager;
    @Autowired
    private CalibrationManager calibraManager;
    @Autowired
    private CalibrationDetailManager calibraDetailManager;
    @Autowired
    private BizWinBiddingNoticeManager winBidNoticeManager;
    @Autowired
    private BizWinBiddingNoticeDetaileManager winBidNoticeDetailManager;
    @Autowired
    private MatApprovalQualificationManager matApprovalQualificationManager;
    @Autowired
    private PurchasingApplicationManager applicationManager;
    @Autowired
    private PurchasingApplicationDetailsManager applicationDetailsManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private BizBidEvaluationManager bidEvaluationManager;
    @Autowired
    private BizBiddingQuotationManager quotationManager;
    @Autowired
    private BizEvaluationSystemManager evaluationSystemManager;
    @Autowired
    private BizEvaluationSystemDescriptionManager evaluationSystemDescriptionManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private SysDictionaryManager sysDictionaryManager;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    private OrgManager orgManager;
    @Autowired
    private OrgUserManager orgUserManager;
    @Autowired
    private PurchasingApplicationManager purchasingApplicationManager;

    @Override
    public MatApproval getByIdNoTenantId(String id) {
        MatApproval result = baseMapper.getByIdNoTenantId(id);
        return result;
    }

    @Override
    public PageList<MatApproval> queryByPage(QueryFilter<MatApproval> queryFilter) {
        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"AFFILIATED_ORG_ID_");
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<MatApproval> queryAllByPage(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void removeByIds(List<String> ids) {
        //删除明细，还原采购申请明细状态
        LambdaQueryWrapper<MatApprovalDetails> detailsQW = new LambdaQueryWrapper<>();
        detailsQW.in(MatApprovalDetails::getNoticeId,ids)
                .eq(MatApprovalDetails::getIsDele,"0");
        List<MatApprovalDetails> detailList = matApprovalDetailsManager.list(detailsQW);
        if(BeanUtils.isNotEmpty(detailList) && detailList.size()>0){
            List<String> purAppDetailIds = detailList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());

            if(BeanUtils.isNotEmpty(purAppDetailIds) && purAppDetailIds.size()>0){
                LambdaUpdateWrapper<PurchasingApplicationDetails> purAppDetailUW = new LambdaUpdateWrapper<>();
                purAppDetailUW.set(PurchasingApplicationDetails::getStatus,1)
                        .in(PurchasingApplicationDetails::getId,purAppDetailIds);
                applicationDetailsManager.update(purAppDetailUW);
            }

            List<String> purAppIds = detailList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());

            if(BeanUtils.isNotEmpty(purAppIds) && purAppIds.size()>0){
                LambdaUpdateWrapper<PurchasingApplication> purAppUW = new LambdaUpdateWrapper<>();
                purAppUW.set(PurchasingApplication::getStatus,3)
                        .in(PurchasingApplication::getId,purAppIds)
                        .eq(PurchasingApplication::getIsDele,"0");
                applicationManager.update(purAppUW);
            }

            matApprovalDetailsManager.remove(detailsQW);
        }

        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public MatApproval saveOrUpdateEntity(MatApproval entity) {
        List<MatApprovalDetails> detailsList = entity.getDetailsList();
        List<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalList = entity.getQuotationTemplateDetailApprovalList();
        TenderDocument zbDocument = entity.getZbDocument();
//        TenderDocument byDocument = entity.getByDocument();
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        List<ApprovalInviteVendor> approvalInviteVendorList = entity.getApprovalInviteVendorList();
        List<MatApprovalQualification> matApprovalQualificationList = entity.getMatApprovalQualificationList();
        BizEvaluationSystem evaTemplate = entity.getEvaTemplate();

        if(BeanUtils.isEmpty(entity.getId())){
            //新增
            entity.setProjectNumber(BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cglx"));

            if(BeanUtils.isEmpty(entity.getAffiliatedUserId())){
                entity.setAffiliatedUserId(ContextUtil.getCurrentUserId());
            }
            if(BeanUtils.isEmpty(entity.getNoticeReleaseUserAccount())){
                entity.setNoticeReleaseUserAccount(ContextUtil.getCurrentUserAccount());
            }

            IGroup org = ContextUtil.getCurrentGroup();
            entity.setAffiliatedOrgId(org.getGroupId());
            entity.setAffiliatedOrgCode(org.getGroupCode());
            entity.setAffiliatedOrgName(org.getName());
            if(entity.getReleaseStatus()==2){
                entity.setBidStatus(3);
            }else {
                entity.setBidStatus(2);
            }

            if(BeanUtils.isEmpty(entity.getCalibraStatus())){
                entity.setCalibraStatus(0);
            }
            if(BeanUtils.isEmpty(entity.getWinNoticeStatus())){
                entity.setWinNoticeStatus(1);
            }
            if(BeanUtils.isEmpty(entity.getPublicityStatus())){
                entity.setPublicityStatus(1);
            }
            if(BeanUtils.isEmpty(entity.getAllocationOfShares())){
                entity.setAllocationOfShares(1);
            }

        }else {
            //更新，删除原始明细
            LambdaQueryWrapper<MatApprovalDetails> detailsQW = new LambdaQueryWrapper<>();
            detailsQW.eq(MatApprovalDetails::getNoticeId,entity.getId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            List<MatApprovalDetails> hisDetailList = matApprovalDetailsManager.list(detailsQW);
            if(BeanUtils.isNotEmpty(hisDetailList) && hisDetailList.size()>0){
                if(entity.getDetailSourceType()==1){
                    //采购申请引入
                    List<String> purAppDetailIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
                    LambdaUpdateWrapper<PurchasingApplicationDetails> purAppDetailUW = new LambdaUpdateWrapper<>();
                    purAppDetailUW.set(PurchasingApplicationDetails::getStatus,1)
                            .in(PurchasingApplicationDetails::getId,purAppDetailIds);
                    applicationDetailsManager.update(purAppDetailUW);
                    List<String> purAppIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
                    LambdaUpdateWrapper<PurchasingApplication> purAppUW = new LambdaUpdateWrapper<>();
                    purAppUW.set(PurchasingApplication::getStatus,3)
                            .in(PurchasingApplication::getId,purAppIds)
                            .eq(PurchasingApplication::getIsDele,"0");
                    applicationManager.update(purAppUW);
                }

                matApprovalDetailsManager.remove(detailsQW);
            }

            //删除原始报价模版
            LambdaQueryWrapper<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalQW = new LambdaQueryWrapper<>();
            quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId,entity.getId())
                    .eq(QuotationTemplateDetailApproval::getProjectApprovalType,1);
            quotationTemplateDetailApprovalManager.remove(quotationTemplateDetailApprovalQW);
            //删除原始评标专家
            LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
            evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,entity.getId())
                    .eq(ProjectEvaluationExpert::getProjectApprovalType,1);
            evaluationExpertManager.remove(evaluationExpertQW);
            //删除原始招标补遗文件
            LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
            tenderDocumentQW.select(TenderDocument::getId)
                    .eq(TenderDocument::getProjectApprovalId,entity.getId())
                    .eq(TenderDocument::getProjectApprovalType,1)
                    .eq(TenderDocument::getIsDele,"0");
            List<Object> objs = tenderDocumentManager.listObjs(tenderDocumentQW);
            if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
                List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                //删除附件
//                LambdaQueryWrapper<Accessory> accessoryQW=new LambdaQueryWrapper<>();
//                accessoryQW.in(Accessory::getSourceId,tenderIds);
//                accessoryService.remove(accessoryQW);
                tenderDocumentManager.removeByIds(tenderIds);
            }

            //删除原始邀请供应商数据
            LambdaQueryWrapper<ApprovalInviteVendor> approvalInviteVendorQW = new LambdaQueryWrapper<>();
            approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId,entity.getId())
                    .eq(ApprovalInviteVendor::getProjectApprovalType,1);
            approvalInviteVendorManager.remove(approvalInviteVendorQW);
            //删除原始资质标签
            LambdaQueryWrapper<MatApprovalQualification> qualificationLabelQW = new LambdaQueryWrapper<>();
            qualificationLabelQW.eq(MatApprovalQualification::getProjectId,entity.getId());
            matApprovalQualificationManager.remove(qualificationLabelQW);

            //删除原始评标模版
            LambdaQueryWrapper<BizEvaluationSystem> evaTemplateQW = new LambdaQueryWrapper<>();
            evaTemplateQW.eq(BizEvaluationSystem::getNoticeId,entity.getId())
                    .eq(BizEvaluationSystem::getNoticeType,1)
                    .orderByDesc(BizEvaluationSystem::getPreparedTime)
                    .last("limit 1");
            BizEvaluationSystem bizEvaluationSystem = evaluationSystemManager.getBaseMapper().selectOne(evaTemplateQW);
            if(BeanUtils.isNotEmpty(bizEvaluationSystem)){
                LambdaQueryWrapper<BizEvaluationSystemDescription> evaTemplateDetailQW = new LambdaQueryWrapper<>();
                evaTemplateDetailQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId,bizEvaluationSystem.getId());
                evaluationSystemDescriptionManager.remove(evaTemplateDetailQW);
            }
            evaluationSystemManager.remove(evaTemplateQW);
        }

        if(BeanUtils.isNotEmpty(evaluationExpertList)){
            entity.setEvaluationExpertNumber(evaluationExpertList.size());
        }

        if(BeanUtils.isEmpty(entity.getQuotationRoundsNum())){
            entity.setQuotationRoundsNum(1);
        }
        super.saveOrUpdate(entity);

        //查询采购申请
        PurchasingApplication application = null;

        if(BeanUtils.isNotEmpty(detailsList) && detailsList.size()>0){
            detailsList.stream().forEach(s->{
                s.setNoticeId(entity.getId());
            });

            if(entity.getDetailSourceType()==1){
                List<String> appIds = new ArrayList<>();
                List<String> disPurAppIdList = detailsList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
                List<String> appDetailIds = detailsList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());

                if(BeanUtils.isNotEmpty(disPurAppIdList) && disPurAppIdList.size()>0){
                    disPurAppIdList.forEach(s->{
                        //查询采购申请中是否包含未立项的数据
                        LambdaQueryWrapper<PurchasingApplicationDetails> countQW = new LambdaQueryWrapper<>();
                        countQW.eq(PurchasingApplicationDetails::getStatus,1)
                                .eq(PurchasingApplicationDetails::getPurchasingApplicationId,s)
                                .notIn(PurchasingApplicationDetails::getId,appDetailIds);
                        if(applicationDetailsManager.count(countQW)==0) {
                            //如果不包含-》更新采购申请状态
                            appIds.add(s);
                        }
                    });
                }

                if(BeanUtils.isNotEmpty(appDetailIds) && appDetailIds.size()>0){
                    //更新采购申请明细状态
                    LambdaUpdateWrapper<PurchasingApplicationDetails> purAppDetailUW = new LambdaUpdateWrapper<>();
                    purAppDetailUW.set(PurchasingApplicationDetails::getStatus,2)
                            .in(PurchasingApplicationDetails::getId,appDetailIds);
                    applicationDetailsManager.update(purAppDetailUW);

                    if(appIds.size()>0){
                        LambdaUpdateWrapper<PurchasingApplication> applicationUW = new LambdaUpdateWrapper<>();
                        applicationUW.set(PurchasingApplication::getStatus,4)
                                .in(PurchasingApplication::getId,appIds)
                                .eq(PurchasingApplication::getIsDele,"0");
                        applicationManager.update(applicationUW);
                    }
                }

                application = applicationManager.getById(detailsList.get(0).getPurchasingApplicationId());
            }

            matApprovalDetailsManager.saveBatch(detailsList);
        }

        if(BeanUtils.isNotEmpty(quotationTemplateDetailApprovalList) && quotationTemplateDetailApprovalList.size()>0){
            quotationTemplateDetailApprovalList.stream().forEach(s->{
                s.setId(null);
                s.setProjectApprovalType(1);
                s.setNoticeId(entity.getId());
            });
            quotationTemplateDetailApprovalManager.saveBatch(quotationTemplateDetailApprovalList);
        }

        if(BeanUtils.isEmpty(evaluationExpertList) || evaluationExpertList.size()<=0){
            evaluationExpertList = new ArrayList<>();
            ProjectEvaluationExpert temp = new ProjectEvaluationExpert();
            if(entity.getDetailSourceType()==1 && application.getIsAgencyProcure()==0){
                //设置评标人为采购制单人
                temp.setEvaluatorType(2);
                temp.setExpertId(application.getPreparedUserId());
                temp.setFullname(application.getPreparedUserName());
                temp.setAccount(userManager.getById(application.getPreparedUserId()).getAccount());
            }else {
                //设置评标人为立项人
                IUser currentUser = ContextUtil.getCurrentUser();
                temp.setEvaluatorType(3);
                temp.setExpertId(currentUser.getUserId());
                temp.setFullname(currentUser.getFullname());
                temp.setAccount(currentUser.getAccount());
            }
            evaluationExpertList.add(temp);
        }

        if(evaluationExpertList.size()>0){
            evaluationExpertList.stream().forEach(s->{
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            evaluationExpertManager.saveBatch(evaluationExpertList);
        }

        List<Accessory> accessoryData = new ArrayList<>();
        if(BeanUtils.isNotEmpty(zbDocument)){
            List<Accessory> accessoryList = zbDocument.getAccessoryList();
            zbDocument.setProjectApprovalType(1);
            zbDocument.setProjectApprovalId(entity.getId());
            zbDocument.setReleaseStatus(2);
            tenderDocumentManager.save(zbDocument);
            accessoryList.stream().forEach(accessory->{
                accessory.setSourceId(zbDocument.getId());
            });
            accessoryData.addAll(accessoryList);
        }

//        if(BeanUtils.isNotEmpty(byDocument)){
//            List<Accessory> accessoryList = byDocument.getAccessoryList();
//            byDocument.setProjectApprovalType(1);
//            byDocument.setProjectApprovalId(entity.getId());
//            tenderDocumentManager.save(byDocument);
//            accessoryList.stream().forEach(accessory->{
//                accessory.setSourceId(byDocument.getId());
//            });
//            accessoryData.addAll(accessoryList);
//        }

        accessoryService.saveBatch(accessoryData);

        //保存邀请供应商数据
        if(BeanUtils.isNotEmpty(approvalInviteVendorList) && approvalInviteVendorList.size()>0){
            approvalInviteVendorList.stream().forEach(s->{
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            approvalInviteVendorManager.saveBatch(approvalInviteVendorList);
        }

        if(BeanUtils.isNotEmpty(matApprovalQualificationList) && matApprovalQualificationList.size()>0){
            matApprovalQualificationList.stream().forEach(s->s.setProjectId(entity.getId()));
            matApprovalQualificationManager.saveBatch(matApprovalQualificationList);
        }

        if(BeanUtils.isNotEmpty(evaTemplate)){
            evaTemplate.setNoticeId(entity.getId());
            evaTemplate.setNoticeType(1);
            evaTemplate.setEvaType(1);
            evaTemplate.setPreparedOrgId(ContextUtil.getCurrentOrgId());
            evaTemplate.setPreparedTime(LocalDateTime.now());
            List<BizEvaluationSystemDescription> descriptionList = evaTemplate.getDescriptionList();
            evaluationSystemManager.save(evaTemplate);
            descriptionList.stream().forEach(s->s.setEvaluationSystemId(evaTemplate.getId()));
            evaluationSystemDescriptionManager.saveBatch(descriptionList);

            LambdaUpdateWrapper<MatApproval> matApprovalUW = new LambdaUpdateWrapper<>();
            matApprovalUW.set(MatApproval::getEvaluationTemplateId,evaTemplate.getId())
                    .eq(MatApproval::getId,entity.getId())
                    .eq(MatApproval::getIsDele,"0");
            super.update(matApprovalUW);
        }

        return entity;
    }

    //2024-07-27 10:55
//    @Override
//    @Transactional
//    public void saveOrUpdateEntity(MatApproval entity) {
//        List<MatApprovalDetails> detailsList = entity.getDetailsList();
//        List<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalList = entity.getQuotationTemplateDetailApprovalList();
//        TenderDocument zbDocument = entity.getZbDocument();
////        TenderDocument byDocument = entity.getByDocument();
//        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
//        List<ApprovalInviteVendor> approvalInviteVendorList = entity.getApprovalInviteVendorList();
//        List<MatApprovalQualification> matApprovalQualificationList = entity.getMatApprovalQualificationList();
//        BizEvaluationSystem evaTemplate = entity.getEvaTemplate();
//
//        if(entity.getEvaluationMethod()==2){
//            //综合评标法
//            //如果没有录入评标模版
//            if(BeanUtils.isEmpty(evaTemplate) || BeanUtils.isEmpty(evaTemplate.getDescriptionList()) || evaTemplate.getDescriptionList().size()<=0){
//                throw new BaseException("综合评标法必须维护评标模版");
//            }
//            //如果没有选择评标专家
//            if(BeanUtils.isEmpty(evaluationExpertList) || evaluationExpertList.size()<=0){
//                throw new BaseException("综合评标法必须选择最少3名以上评标专家");
//            }
//        }
//
//        if(BeanUtils.isEmpty(entity.getId())){
//            //新增
//            String cgpt_cglx = BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cglx");
//            entity.setProjectNumber(cgpt_cglx);
//
//            entity.setAffiliatedUserId(ContextUtil.getCurrentUserId());
//
//            IGroup org = ContextUtil.getCurrentGroup();
//            entity.setAffiliatedOrgId(org.getGroupId());
//            entity.setAffiliatedOrgCode(org.getGroupCode());
//            entity.setAffiliatedOrgName(org.getName());
//            if(entity.getReleaseStatus()==2){
//                entity.setBidStatus(3);
//            }else {
//                entity.setBidStatus(2);
//            }
//        }else {
//            //更新，删除原始明细
//            LambdaQueryWrapper<MatApprovalDetails> detailsQW = new LambdaQueryWrapper<>();
//            detailsQW.eq(MatApprovalDetails::getNoticeId,entity.getId())
//                    .eq(MatApprovalDetails::getIsDele,"0");
//            List<MatApprovalDetails> hisDetailList = matApprovalDetailsManager.list(detailsQW);
//            if(BeanUtils.isNotEmpty(hisDetailList) && hisDetailList.size()>0){
//                if(entity.getDetailSourceType()==1){
//                    //采购申请引入
//                    List<String> purAppDetailIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
//                    LambdaUpdateWrapper<PurchasingApplicationDetails> purAppDetailUW = new LambdaUpdateWrapper<>();
//                    purAppDetailUW.set(PurchasingApplicationDetails::getStatus,1)
//                            .in(PurchasingApplicationDetails::getId,purAppDetailIds);
//                    applicationDetailsManager.update(purAppDetailUW);
//                    List<String> purAppIds = hisDetailList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
//                    LambdaUpdateWrapper<PurchasingApplication> purAppUW = new LambdaUpdateWrapper<>();
//                    purAppUW.set(PurchasingApplication::getStatus,3)
//                            .in(PurchasingApplication::getId,purAppIds)
//                            .eq(PurchasingApplication::getIsDele,"0");
//                    applicationManager.update(purAppUW);
//                }
//
//                matApprovalDetailsManager.remove(detailsQW);
//            }
//
//            //删除原始报价模版
//            LambdaQueryWrapper<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalQW = new LambdaQueryWrapper<>();
//            quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId,entity.getId())
//                    .eq(QuotationTemplateDetailApproval::getProjectApprovalType,1);
//            quotationTemplateDetailApprovalManager.remove(quotationTemplateDetailApprovalQW);
//            //删除原始评标专家
//            LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
//            evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,entity.getId())
//                    .eq(ProjectEvaluationExpert::getProjectApprovalType,1);
//            evaluationExpertManager.remove(evaluationExpertQW);
//            //删除原始招标补遗文件
//            LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//            tenderDocumentQW.select(TenderDocument::getId)
//                    .eq(TenderDocument::getProjectApprovalId,entity.getId())
//                    .eq(TenderDocument::getProjectApprovalType,1)
//                    .eq(TenderDocument::getIsDele,"0");
//            List<Object> objs = tenderDocumentManager.listObjs(tenderDocumentQW);
//            if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
//                List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
//                //删除附件
////                LambdaQueryWrapper<Accessory> accessoryQW=new LambdaQueryWrapper<>();
////                accessoryQW.in(Accessory::getSourceId,tenderIds);
////                accessoryService.remove(accessoryQW);
//                tenderDocumentManager.removeByIds(tenderIds);
//            }
//
//            //删除原始邀请供应商数据
//            LambdaQueryWrapper<ApprovalInviteVendor> approvalInviteVendorQW = new LambdaQueryWrapper<>();
//            approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId,entity.getId())
//                    .eq(ApprovalInviteVendor::getProjectApprovalType,1);
//            approvalInviteVendorManager.remove(approvalInviteVendorQW);
//            //删除原始资质标签
//            LambdaQueryWrapper<MatApprovalQualification> qualificationLabelQW = new LambdaQueryWrapper<>();
//            qualificationLabelQW.eq(MatApprovalQualification::getProjectId,entity.getId());
//            matApprovalQualificationManager.remove(qualificationLabelQW);
//            //删除原始评标模版
//            LambdaQueryWrapper<BizEvaluationSystem> evaTemplateQW = new LambdaQueryWrapper<>();
//            evaTemplateQW.eq(BizEvaluationSystem::getNoticeId,entity.getId())
//                    .orderByDesc(BizEvaluationSystem::getPreparedTime)
//                    .last("limit 1");
//            BizEvaluationSystem bizEvaluationSystem = evaluationSystemManager.getBaseMapper().selectOne(evaTemplateQW);
//            if(BeanUtils.isNotEmpty(bizEvaluationSystem)){
//                LambdaQueryWrapper<BizEvaluationSystemDescription> evaTemplateDetailQW = new LambdaQueryWrapper<>();
//                evaTemplateDetailQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId,bizEvaluationSystem.getId());
//                evaluationSystemDescriptionManager.remove(evaTemplateDetailQW);
//            }
//            evaluationSystemManager.remove(evaTemplateQW);
//        }
//
//        if(BeanUtils.isNotEmpty(evaluationExpertList)){
//            entity.setEvaluationExpertNumber(evaluationExpertList.size());
//        }
//        super.saveOrUpdate(entity);
//
//        //查询采购申请
//        PurchasingApplication application = null;
//
//        if(BeanUtils.isNotEmpty(detailsList) && detailsList.size()>0){
//            detailsList.stream().forEach(s->{
//                s.setNoticeId(entity.getId());
//            });
//
//            if(entity.getDetailSourceType()==1){
//                List<String> appIds = new ArrayList<>();
//                List<String> disPurAppIdList = detailsList.stream().map(s -> s.getPurchasingApplicationId()).distinct().collect(Collectors.toList());
//                List<String> appDetailIds = detailsList.stream().map(s -> s.getPurchasingApplicationDetailId()).distinct().collect(Collectors.toList());
//
//                if(BeanUtils.isNotEmpty(disPurAppIdList) && disPurAppIdList.size()>0){
//                    disPurAppIdList.forEach(s->{
//                        //查询采购申请中是否包含未立项的数据
//                        LambdaQueryWrapper<PurchasingApplicationDetails> countQW = new LambdaQueryWrapper<>();
//                        countQW.eq(PurchasingApplicationDetails::getStatus,1)
//                                .eq(PurchasingApplicationDetails::getPurchasingApplicationId,s)
//                                .notIn(PurchasingApplicationDetails::getId,appDetailIds);
//                        if(applicationDetailsManager.count(countQW)==0) {
//                            //如果不包含-》更新采购申请状态
//                            appIds.add(s);
//                        }
//                    });
//                }
//
//                if(BeanUtils.isNotEmpty(appDetailIds) && appDetailIds.size()>0){
//                    //更新采购申请明细状态
//                    LambdaUpdateWrapper<PurchasingApplicationDetails> purAppDetailUW = new LambdaUpdateWrapper<>();
//                    purAppDetailUW.set(PurchasingApplicationDetails::getStatus,2)
//                            .in(PurchasingApplicationDetails::getId,appDetailIds);
//                    applicationDetailsManager.update(purAppDetailUW);
//
//                    if(appIds.size()>0){
//                        LambdaUpdateWrapper<PurchasingApplication> applicationUW = new LambdaUpdateWrapper<>();
//                        applicationUW.set(PurchasingApplication::getStatus,4)
//                                .in(PurchasingApplication::getId,appIds)
//                                .eq(PurchasingApplication::getIsDele,"0");
//                        applicationManager.update(applicationUW);
//                    }
//                }
//
//                application = applicationManager.getById(detailsList.get(0).getPurchasingApplicationId());
//            }
//
//            matApprovalDetailsManager.saveBatch(detailsList);
//        }
//
//        if(BeanUtils.isNotEmpty(quotationTemplateDetailApprovalList) && quotationTemplateDetailApprovalList.size()>0){
//            quotationTemplateDetailApprovalList.stream().forEach(s->{
//                s.setId(null);
//                s.setProjectApprovalType(1);
//                s.setNoticeId(entity.getId());
//            });
//            quotationTemplateDetailApprovalManager.saveBatch(quotationTemplateDetailApprovalList);
//        }
//
//        if(BeanUtils.isEmpty(evaluationExpertList) || evaluationExpertList.size()<=0){
//            evaluationExpertList = new ArrayList<>();
//            ProjectEvaluationExpert temp = new ProjectEvaluationExpert();
//            if(entity.getDetailSourceType()==1){
//                //设置评标人为采购制单人
//                temp.setEvaluatorType(2);
//                temp.setExpertId(application.getPreparedUserId());
//                temp.setFullname(application.getPreparedUserName());
//                temp.setAccount(userManager.getById(application.getPreparedUserId()).getAccount());
//            }else {
//                //设置评标人为立项人
//                IUser currentUser = ContextUtil.getCurrentUser();
//                temp.setEvaluatorType(3);
//                temp.setExpertId(currentUser.getUserId());
//                temp.setFullname(currentUser.getFullname());
//                temp.setAccount(currentUser.getAccount());
//            }
//            evaluationExpertList.add(temp);
//        }
//
//        evaluationExpertList.stream().forEach(s->{
//            s.setId(null);
//            s.setProjectApprovalId(entity.getId());
//            s.setProjectApprovalType(1);
//        });
//        evaluationExpertManager.saveBatch(evaluationExpertList);
//
//        List<Accessory> accessoryData = new ArrayList<>();
//        if(BeanUtils.isNotEmpty(zbDocument)){
//            List<Accessory> accessoryList = zbDocument.getAccessoryList();
//            zbDocument.setProjectApprovalType(1);
//            zbDocument.setProjectApprovalId(entity.getId());
//            zbDocument.setReleaseStatus(2);
//            tenderDocumentManager.save(zbDocument);
//            accessoryList.stream().forEach(accessory->{
//                accessory.setSourceId(zbDocument.getId());
//            });
//            accessoryData.addAll(accessoryList);
//        }
//
////        if(BeanUtils.isNotEmpty(byDocument)){
////            List<Accessory> accessoryList = byDocument.getAccessoryList();
////            byDocument.setProjectApprovalType(1);
////            byDocument.setProjectApprovalId(entity.getId());
////            tenderDocumentManager.save(byDocument);
////            accessoryList.stream().forEach(accessory->{
////                accessory.setSourceId(byDocument.getId());
////            });
////            accessoryData.addAll(accessoryList);
////        }
//
//        accessoryService.saveBatch(accessoryData);
//
//        //保存邀请供应商数据
//        if(BeanUtils.isNotEmpty(approvalInviteVendorList) && approvalInviteVendorList.size()>0){
//            approvalInviteVendorList.stream().forEach(s->{
//                s.setProjectApprovalId(entity.getId());
//                s.setProjectApprovalType(1);
//            });
//            approvalInviteVendorManager.saveBatch(approvalInviteVendorList);
//        }
//
//        if(BeanUtils.isNotEmpty(matApprovalQualificationList) && matApprovalQualificationList.size()>0){
//            matApprovalQualificationList.stream().forEach(s->s.setProjectId(entity.getId()));
//            matApprovalQualificationManager.saveBatch(matApprovalQualificationList);
//        }
//
//        if(BeanUtils.isNotEmpty(evaTemplate)){
//            evaTemplate.setNoticeId(entity.getId());
//            evaTemplate.setNoticeType(1);
//            evaTemplate.setEvaType(1);
//            evaTemplate.setPreparedOrgId(ContextUtil.getCurrentOrgId());
//            evaTemplate.setPreparedTime(LocalDateTime.now());
//            List<BizEvaluationSystemDescription> descriptionList = evaTemplate.getDescriptionList();
//            evaluationSystemManager.save(evaTemplate);
//            descriptionList.stream().forEach(s->s.setEvaluationSystemId(evaTemplate.getId()));
//            evaluationSystemDescriptionManager.saveBatch(descriptionList);
//
//            LambdaUpdateWrapper<MatApproval> matApprovalUW = new LambdaUpdateWrapper<>();
//            matApprovalUW.set(MatApproval::getEvaluationTemplateId,evaTemplate.getId())
//                    .eq(MatApproval::getId,entity.getId())
//                    .eq(MatApproval::getIsDele,"0");
//            super.update(matApprovalUW);
//        }
//
//    }

    //2024-05-22 15:03
//    @Override
//    @Transactional
//    public void uploadTenderDoc(MatApproval entity) {
//        TenderDocument byDocument = entity.getByDocument();
//
////        //删除原始补遗文件
////        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
////        tenderDocumentQW.select(TenderDocument::getId)
////                .eq(TenderDocument::getProjectApprovalId,entity.getId())
////                .eq(TenderDocument::getProjectApprovalType,1)
////                .eq(TenderDocument::getType,2)
////                .eq(TenderDocument::getIsDele,"0");
////        List<Object> objs = tenderDocumentManager.listObjs(tenderDocumentQW);
////        if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
////            List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
////            //删除附件
////            LambdaQueryWrapper<Accessory> accessoryQW=new LambdaQueryWrapper<>();
////            accessoryQW.in(Accessory::getSourceId,tenderIds);
////            accessoryService.remove(accessoryQW);
////            tenderDocumentManager.removeByIds(tenderIds);
////        }
//
//        if(BeanUtils.isNotEmpty(byDocument)){
//            List<Accessory> accessoryList = byDocument.getAccessoryList();
//            if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
//                //1.查询该立项是否有补遗文件数据
//                LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//                tenderDocumentQW.eq(TenderDocument::getType,2)
//                        .eq(TenderDocument::getProjectApprovalType,1)
//                        .eq(TenderDocument::getProjectApprovalId,entity.getId())
//                        .last("limit 1");
//                TenderDocument tdHis = tenderDocumentManager.getBaseMapper().selectOne(tenderDocumentQW);
//                String tdId;
//                if(BeanUtils.isNotEmpty(tdHis)){
//                    tdId = tdHis.getId();
//                }else {
//                    byDocument.setProjectApprovalType(1);
//                    byDocument.setType(2);
//                    byDocument.setReleaseStatus(1);
//                    byDocument.setProjectApprovalId(entity.getId());
//                    tenderDocumentManager.save(byDocument);
//                    tdId = byDocument.getId();
//                }
//
//                accessoryList.stream().forEach(accessory->{
//                    accessory.setSourceId(tdId);
//                });
//                accessoryService.saveBatch(accessoryList);
//            }
//
//        }
//    }

    @Override
    @Transactional
    public void uploadTenderDoc(MatApproval entity) {
        List<TenderDocument> byDocumentList = entity.getByDocument();

//        //删除原始补遗文件
//        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
//        tenderDocumentQW.select(TenderDocument::getId)
//                .eq(TenderDocument::getProjectApprovalId,entity.getId())
//                .eq(TenderDocument::getProjectApprovalType,1)
//                .eq(TenderDocument::getType,2)
//                .eq(TenderDocument::getIsDele,"0");
//        List<Object> objs = tenderDocumentManager.listObjs(tenderDocumentQW);
//        if(BeanUtils.isNotEmpty(objs) && objs.size()>0){
//            List<String> tenderIds = objs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
//            //删除附件
//            LambdaQueryWrapper<Accessory> accessoryQW=new LambdaQueryWrapper<>();
//            accessoryQW.in(Accessory::getSourceId,tenderIds);
//            accessoryService.remove(accessoryQW);
//            tenderDocumentManager.removeByIds(tenderIds);
//        }

        if(BeanUtils.isNotEmpty(byDocumentList) && byDocumentList.size()>0){
            for(TenderDocument byDocument : byDocumentList){
                List<Accessory> accessoryList = byDocument.getAccessoryList();
                if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
                    byDocument.setProjectApprovalType(1);
                    byDocument.setType(2);
                    byDocument.setReleaseStatus(1);
                    byDocument.setProjectApprovalId(entity.getId());
                    tenderDocumentManager.save(byDocument);
                    accessoryList.stream().forEach(accessory->{
                        accessory.setSourceId(byDocument.getId());
                    });
                    accessoryService.saveBatch(accessoryList);
                }
            }
        }

    }

    @Override
    @Transactional
    public void modifyBidStatus(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper<MatApproval> approvalUW = new LambdaUpdateWrapper<>();
        approvalUW.set(MatApproval::getBidStatus,status)
                .in(MatApproval::getId, idList)
                .eq(MatApproval::getIsDele,"0");
        super.update(approvalUW);
    }

    @Override
    @Transactional
    public void modifyReleaseStatus(String ids, String status) {
        LocalDateTime nowTime = LocalDateTime.now();
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper<MatApproval> approvalUW = new LambdaUpdateWrapper<>();
        approvalUW.set(MatApproval::getReleaseStatus,status)
                .in(MatApproval::getId, idList)
                .eq(MatApproval::getIsDele,"0");
        if(status.equals("2")){
            //已发布
            approvalUW.set(MatApproval::getBidStatus,3)
                    .set(MatApproval::getNoticeReleaseTime,nowTime);
        }

        if(status.equals("3")){
            //已下架
            //查询项目是否有人参与报名，如果有就不能下架
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.in(UserParticipation::getNoticeId,idList)
                    .notIn(UserParticipation::getStatus,Arrays.asList("5,6"))
                    .eq(UserParticipation::getIsDele,"0");
            if(userParticipationManager.count(userParticipationQW)>0){
                throw new BaseException("已有用户参与报名，下架失败");
            }

            approvalUW.set(MatApproval::getBidStatus,2)
                    .set(MatApproval::getNoticeOffTime,LocalDateTime.now());
        }

        super.update(approvalUW);

        if(status.equals("2")){
            //已发布
            LambdaQueryWrapper<MatApproval> matApprovalQW = new LambdaQueryWrapper<>();
            matApprovalQW.in(MatApproval::getId,idList)
//                    .eq(MatApproval::getReleaseMethod,1)
                    .eq(MatApproval::getIsDele,"0");
            List<MatApproval> matApprovalList = super.list(matApprovalQW);

            List<DictModel> cglxDic = sysDictionaryManager.queryDictListItemsByCode("cglx-cglx");

            for(MatApproval notice : matApprovalList){
                //保存公告id到redis，并设置过期时间为报名结束时间
                String noticeRedisKey = "matApproval:" + notice.getId();
                //获取结束报名时间秒数
                long endTime = notice.getResponseTimeDeadline().toEpochSecond(ZoneOffset.of("+8"));
                //获取当前时间戳
                long currentTime = nowTime.toEpochSecond(ZoneOffset.of("+8"));
                //报名结束时间戳-当前时间戳=过期时间(提前1分钟)
                redisUtil.set(noticeRedisKey, 0, endTime-currentTime-60*1);
                //设置一个备份键
                redisUtil.set("backups"+noticeRedisKey, 0);

                //推送公告到门户
                try {
                    PushNoticeVO mhNoticeVO = new PushNoticeVO();
                    mhNoticeVO.setProjectCode(notice.getProjectNumber());
                    mhNoticeVO.setContent(notice.getEstablishmentName());
                    mhNoticeVO.setNoticeTitle(notice.getNoticeTitle());
                    mhNoticeVO.setAffCompany(notice.getProcureOrgName());
                    if(notice.getProcureType()==2){
                        //询比价
                        mhNoticeVO.setNoticeType(2);
                    }else if (notice.getProcureType()==4){
                        //份额采购（谈判）
                        mhNoticeVO.setNoticeType(3);
                    }else {
                        mhNoticeVO.setNoticeType(1);
                    }

                    mhNoticeVO.setCategory(1);
                    mhNoticeVO.setReleaseTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setStartRegistrationTime(notice.getNoticeReleaseTime());
                    mhNoticeVO.setEndRegistrationTime(notice.getResponseTimeDeadline());
                    mhNoticeVO.setStartAuctionTime(notice.getBiddingStartTime());
                    mhNoticeVO.setEndAuctionTime(notice.getBiddingEndTime());
                    mhNoticeVO.setStatus(1);
                    mhNoticeVO.setDetailedUrl(cgptPushNoticeUrl+notice.getId());
                    foreignCallService.pushNoticeToMh(mhNoticeVO);
                } catch (Exception e){
                    e.printStackTrace();
                    System.out.println("立项公告发布到门户失败："+e.getMessage());
                }

                //推送模版消息到微信公众号
                String wxResult = "";
                try {
//                    String replaceUrl = wxNoticeMsgUrl.replace("CustomUrl",pushWxNoticeUrl+notice.getId());
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
//                    WxNoticeTemplate wxTemplate = new WxNoticeTemplate(notice.getNoticeTitle(),
//                            notice.getAffiliatedCompanyName(), notice.getMatCategoryName()+"竞价",
//                            notice.getNoticeReleaseTime().format(formatter),replaceUrl);

                    String s = notice.getProcureType().toString();
                    String cglxStr = BizUtils.getDicValueByCode(cglxDic,s);
                    WxNoticeTemplate wxTemplate = new WxNoticeTemplate(notice.getProcureOrgName(),
                            notice.getNoticeTitle(),cglxStr, notice.getNoticeReleaseTime().format(formatter));
                    wxTemplate.setTemplateId(wxNoticeTemplateId);
//                wxTemplate.setUserAccount("admin");
                    wxResult = foreignCallService.pushWxMessage(wxTemplate).toString();
                }catch (Exception e){
                    e.printStackTrace();
                    wxResult = e.getMessage();
                } finally {
                    System.out.println("推送立项公告到微信公众号："+wxResult);
                }

            }

        }

    }

    @Override
    @Transactional
    public void modifyCalibraStatus(String ids, String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        List<MatApproval> matApprovals = super.listByIds(idList);

        Integer evaStatus = null;
        if(status.equals("1")){
            //审批中
            evaStatus = 2;
        }else if(status.equals("2")){
            //已定标
            evaStatus = 3;
        }else {
            evaStatus = 1;
        }

        for(MatApproval approval : matApprovals){
            //评标方法（1.最低价评标法，2.综合评标法）
            if(approval.getEvaluationMethod()==1){
                //最低价评标法
                QueryFilter<BizBidEvaluation> evaQF = QueryFilter.build();
                evaQF.setPageBean(new PageBean(0,-1,false));
                evaQF.addFilter("a.NOTICE_ID_",approval.getId(),QueryOP.EQUAL);
                List<BizBidEvaluation> evaList = bidEvaluationManager.getCalibraDetailById(evaQF).getRows();

                //更新评标表状态
                LambdaUpdateWrapper<BizBidEvaluation> evaUW = new LambdaUpdateWrapper<>();
                evaUW.set(BizBidEvaluation::getStatus,evaStatus)
                        .in(BizBidEvaluation::getNoticeId,idList)
                        .eq(BizBidEvaluation::getNoticeType,1)
                        .eq(BizBidEvaluation::getIsDele,"0");
                bidEvaluationManager.update(evaUW);
            }else {
                //综合评标法
                if(approval.getEvaluationMode()==1){
                    //以物料评标
                    QueryFilter<BizBidEvaluation> evaQF = QueryFilter.build();
                    evaQF.setPageBean(new PageBean(0,-1,false));
                    evaQF.addFilter("a.NOTICE_ID_",approval.getId(),QueryOP.EQUAL);
                    List<BizBidEvaluation> evaList = bidEvaluationManager.getCalibraDetailComprehensive(evaQF).getRows();
                    Integer finalEvaStatus = evaStatus;
                    evaList.stream().forEach(s->s.setStatus(finalEvaStatus));
                    bidEvaluationManager.updateBatchById(evaList);
                }else {
                    //以供应商评标
                    List<BizBidEvaluation> evaList = bidEvaluationManager.getCalibraDetailMaxScoreById(approval.getId());
                    Integer finalEvaStatus = evaStatus;
                    evaList.stream().forEach(s->s.setStatus(finalEvaStatus));
                    bidEvaluationManager.updateBatchById(evaList);
                }

            }
        }

        //更新立项定标状态
        LambdaUpdateWrapper<MatApproval> approvalUW = new LambdaUpdateWrapper<>();
        approvalUW.set(MatApproval::getCalibraStatus,status)
                .in(MatApproval::getId,idList)
                .eq(MatApproval::getIsDele,"0");
        super.update(approvalUW);
    }

    @Override
    @Transactional
    public void modifyPublicityStatus(String ids, String status) {
        LambdaUpdateWrapper<MatApproval> approvalUW = new LambdaUpdateWrapper<>();
        approvalUW.set(MatApproval::getPublicityStatus,status)
                .in(MatApproval::getId, Arrays.asList(ids.split(",")))
                .eq(MatApproval::getIsDele,"0");
        super.update(approvalUW);
    }

    @Override
    public MatApproval getDataById(String id) {
        MatApproval result = super.getById(id);
        //查询立项明细
        LambdaQueryWrapper<MatApprovalDetails> detailsQW = new LambdaQueryWrapper<>();
        detailsQW.eq(MatApprovalDetails::getNoticeId,id)
                .eq(MatApprovalDetails::getIsDele,"0");
        result.setDetailsList(matApprovalDetailsManager.list(detailsQW));

        //查询报价模版
        LambdaQueryWrapper<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalQW = new LambdaQueryWrapper<>();
        quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId,id)
                .eq(QuotationTemplateDetailApproval::getProjectApprovalType,1)
                .eq(QuotationTemplateDetailApproval::getIsDele,"0");
        result.setQuotationTemplateDetailApprovalList(quotationTemplateDetailApprovalManager.list(quotationTemplateDetailApprovalQW));

        //查询评标专家
        LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
        evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,id)
                .eq(ProjectEvaluationExpert::getProjectApprovalType,1)
                .eq(ProjectEvaluationExpert::getIsDele,"0");
        result.setProjectEvaluationExpertList(evaluationExpertManager.list(evaluationExpertQW));

        //查询邀请供应商
        LambdaQueryWrapper<ApprovalInviteVendor> approvalInviteVendorQW = new LambdaQueryWrapper<>();
        approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId,id)
                .eq(ApprovalInviteVendor::getProjectApprovalType,1);
        result.setApprovalInviteVendorList(approvalInviteVendorManager.list(approvalInviteVendorQW));

        LambdaQueryWrapper<MatApprovalQualification> qualificationLabelQW = new LambdaQueryWrapper<>();
        qualificationLabelQW.eq(MatApprovalQualification::getProjectId,id);
        result.setMatApprovalQualificationList(matApprovalQualificationManager.list(qualificationLabelQW));

        //查询招标/补遗文件
        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,id)
                .eq(TenderDocument::getProjectApprovalType,1)
                .isNotNull(TenderDocument::getType)
                .eq(TenderDocument::getIsDele,"0");
        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);

        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));

            //招标文件
            List<TenderDocument> zbDocument = collect.get(1);
            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }

            //补遗文件
            List<TenderDocument> byDocument = collect.get(2);
            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
                byDocument.stream().forEach(s->{
                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
                });
                result.setByDocument(byDocument);
            }

        }


        //查询评标模版
        LambdaQueryWrapper<BizEvaluationSystem> evaluationSystemQW = new LambdaQueryWrapper<>();
        evaluationSystemQW.eq(BizEvaluationSystem::getNoticeId,result.getId())
                .eq(BizEvaluationSystem::getNoticeType,1)
                .orderByDesc(BizEvaluationSystem::getPreparedTime)
                .last("limit 1");
        BizEvaluationSystem evaluationSystem = evaluationSystemManager.getBaseMapper().selectOne(evaluationSystemQW);
        if(BeanUtils.isNotEmpty(evaluationSystem)){
            LambdaQueryWrapper<BizEvaluationSystemDescription> descriptionQW = new LambdaQueryWrapper<>();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId,evaluationSystem.getId());
            evaluationSystem.setDescriptionList(evaluationSystemDescriptionManager.list(descriptionQW));
            result.setEvaTemplate(evaluationSystem);
        }

        return result;
    }

    @Override
    public MatApproval getReleaseDataById(String id) {
        MatApproval result = super.getById(id);
        //查询立项明细
        LambdaQueryWrapper<MatApprovalDetails> detailsQW = new LambdaQueryWrapper<>();
        detailsQW.eq(MatApprovalDetails::getNoticeId,id)
                .eq(MatApprovalDetails::getIsDele,"0");
        result.setDetailsList(matApprovalDetailsManager.list(detailsQW));

        //查询报价模版
        LambdaQueryWrapper<QuotationTemplateDetailApproval> quotationTemplateDetailApprovalQW = new LambdaQueryWrapper<>();
        quotationTemplateDetailApprovalQW.eq(QuotationTemplateDetailApproval::getNoticeId,id)
                .eq(QuotationTemplateDetailApproval::getProjectApprovalType,1)
                .eq(QuotationTemplateDetailApproval::getIsDele,"0");
        result.setQuotationTemplateDetailApprovalList(quotationTemplateDetailApprovalManager.list(quotationTemplateDetailApprovalQW));

        //查询评标专家
        LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
        evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,id)
                .eq(ProjectEvaluationExpert::getProjectApprovalType,1)
                .eq(ProjectEvaluationExpert::getIsDele,"0");
        result.setProjectEvaluationExpertList(evaluationExpertManager.list(evaluationExpertQW));

        //查询邀请供应商
        LambdaQueryWrapper<ApprovalInviteVendor> approvalInviteVendorQW = new LambdaQueryWrapper<>();
        approvalInviteVendorQW.eq(ApprovalInviteVendor::getProjectApprovalId,id)
                .eq(ApprovalInviteVendor::getProjectApprovalType,1);
        result.setApprovalInviteVendorList(approvalInviteVendorManager.list(approvalInviteVendorQW));

        //查询招标/补遗文件
        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,id)
                .eq(TenderDocument::getProjectApprovalType,1)
                .eq(TenderDocument::getReleaseStatus,2)
                .isNotNull(TenderDocument::getType)
                .eq(TenderDocument::getIsDele,"0");
        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);

        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));

            //招标文件
            List<TenderDocument> zbDocument = collect.get(1);
            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }

            //补遗文件
            List<TenderDocument> byDocument = collect.get(2);
            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
                byDocument.stream().forEach(s->{
                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
                });
                result.setByDocument(byDocument);
            }

        }

        //查询评标模版
        LambdaQueryWrapper<BizEvaluationSystem> evaluationSystemQW = new LambdaQueryWrapper<>();
        evaluationSystemQW.eq(BizEvaluationSystem::getNoticeId,result.getId())
                .eq(BizEvaluationSystem::getNoticeType,1)
                .orderByDesc(BizEvaluationSystem::getPreparedTime)
                .last("limit 1");
        BizEvaluationSystem evaluationSystem = evaluationSystemManager.getBaseMapper().selectOne(evaluationSystemQW);
        if(BeanUtils.isNotEmpty(evaluationSystem)){
            LambdaQueryWrapper<BizEvaluationSystemDescription> descriptionQW = new LambdaQueryWrapper<>();
            descriptionQW.eq(BizEvaluationSystemDescription::getEvaluationSystemId,evaluationSystem.getId());
            evaluationSystem.setDescriptionList(evaluationSystemDescriptionManager.list(descriptionQW));
            result.setEvaTemplate(evaluationSystem);
        }

        return result;
    }

    @Override
    public PageList<MatApproval> signData(QueryFilter<MatApproval> queryFilter) {
        Integer joinStatus = 0;
        List<QueryField> querys = queryFilter.getQuerys();
        if(BeanUtils.isNotEmpty(querys) && querys.size()>0){
            for(QueryField qf : querys){
                if(qf.getProperty().equals("joinStatus")){
                    if((Integer) qf.getValue()==1){
                        joinStatus = 1;
                    }
                    qf.setProperty("1");
                    qf.setValue("1");
                }
            }
        }

        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        List<String> noticeIds = new ArrayList<>();

        //查询已参与的立项
        QueryWrapper<UserParticipation> userPartNoticeQW = new QueryWrapper<>();
        userPartNoticeQW.select("DISTINCT NOTICE_ID_")
                .lambda().eq(UserParticipation::getCompanyId, ContextUtil.getCurrentOrgId())
                .eq(UserParticipation::getNoticeType, 1)
                .eq(UserParticipation::getStatus, 1)
                .eq(UserParticipation::getIsDele, 0);

        if(joinStatus==1) {
            //已参与

            List<Object> noticeIdObjs = userParticipationManager.listObjs(userPartNoticeQW);

            if(BeanUtils.isNotEmpty(noticeIdObjs) && noticeIdObjs.size()>0){
                noticeIds.addAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }
        }else {
            //未参与
//            if(BizUtils.isAdmin(ucFeignService)){
//                queryFilter.addFilter("RELEASE_METHOD_", "2", QueryOP.NOT_EQUAL,FieldRelation.OR,"yq");
//                //1.查询采购类型不为公开邀请或该供应商被邀请的立项
//                QueryWrapper<ApprovalInviteVendor> inviteVendorQW = new QueryWrapper<>();
//                inviteVendorQW.select("DISTINCT PROJECT_APPROVAL_ID_")
//                        .lambda().eq(ApprovalInviteVendor::getVendorId,ContextUtil.getCurrentOrgId())
//                        .eq(ApprovalInviteVendor::getProjectApprovalType,1);
//                List<Object> objList = approvalInviteVendorManager.listObjs(inviteVendorQW);
//                if(BeanUtils.isNotEmpty(objList) && objList.size()>0){
//                    noticeIds.addAll(objList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
//                }
//            }

            //查询所有可参与的立项id
            List<String> list = baseMapper.queryIds(convert2Wrapper(queryFilter, currentModelClass()));
            if(BeanUtils.isEmpty(list) || list.size()<=0){
                return new PageList<>(new ArrayList<MatApproval>());
            }

            userPartNoticeQW.lambda()
                    .in(UserParticipation::getNoticeId, list);
            List<Object> noticeIdObjs = userParticipationManager.listObjs(userPartNoticeQW);

            //过滤掉已参与的立项
            if(BeanUtils.isNotEmpty(noticeIdObjs) && noticeIdObjs.size()>0){
                list.removeAll(noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList()));
            }

            noticeIds.addAll(list);

        }

        if(noticeIds.size()>0){
            queryFilter.addFilter("ID_", noticeIds, QueryOP.IN,FieldRelation.OR,"yq");
        }

        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<MatApproval> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            if(joinStatus==1){
                records.forEach(s->s.setJoinStatus(1));
            }else {
                for(MatApproval notice : records){
                    LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
                    userParticipationQW.eq(UserParticipation::getCompanyId,ContextUtil.getCurrentOrgId())
                            .eq(UserParticipation::getNoticeType,1)
                            .eq(UserParticipation::getNoticeId,notice.getId())
                            .eq(UserParticipation::getIsDele,0).last("limit 1");
                    UserParticipation participation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);
                    if(BeanUtils.isNotEmpty(participation) && BeanUtils.isNotEmpty(participation.getStatus())){
                        notice.setJoinStatus(participation.getStatus());
                        notice.setPartId(participation.getId());
                    }else {
                        notice.setJoinStatus(0);
                    }
                }
            }
        }

        return new PageList<>(result);
    }

    @Override
    public MatApproval getInfoById(String id) {
        MatApproval result = super.getById(id);

        //查询招标/补遗文件
        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,id)
                .eq(TenderDocument::getProjectApprovalType,1)
                .eq(TenderDocument::getReleaseStatus,2)
                .isNotNull(TenderDocument::getType)
                .eq(TenderDocument::getIsDele,"0");
        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);

        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));

            //招标文件
            List<TenderDocument> zbDocument = collect.get(1);
            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }

            //补遗文件
            List<TenderDocument> byDocument = collect.get(2);
            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
                byDocument.stream().forEach(s->{
                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
                });
                result.setByDocument(byDocument);
            }

        }

        result.setJoinStatus(0);
        IUser currentUserOrNull = ContextUtil.getCurrentUserOrNull();
        if(BeanUtils.isNotEmpty(currentUserOrNull)){
            LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
            userParticipationQW.eq(UserParticipation::getCompanyId,ContextUtil.getCurrentOrgId())
                    .eq(UserParticipation::getNoticeType,1)
                    .eq(UserParticipation::getNoticeId,result.getId())
                    .eq(UserParticipation::getIsDele,0).last("limit 1");
            UserParticipation participation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);
            if(BeanUtils.isNotEmpty(participation) && BeanUtils.isNotEmpty(participation.getStatus())){
                result.setJoinStatus(participation.getStatus());
            }
        }

        return result;
    }

    @Override
    public MatApproval getInfoByIdAndUserId(String id,String userId) {
        MatApproval result = super.getById(id);

        //查询招标/补遗文件
        LambdaQueryWrapper<TenderDocument> tenderDocumentQW = new LambdaQueryWrapper<>();
        tenderDocumentQW.eq(TenderDocument::getProjectApprovalId,id)
                .eq(TenderDocument::getProjectApprovalType,1)
                .eq(TenderDocument::getReleaseStatus,2)
                .isNotNull(TenderDocument::getType)
                .eq(TenderDocument::getIsDele,"0");
        List<TenderDocument> documentList = tenderDocumentManager.list(tenderDocumentQW);

        if(BeanUtils.isNotEmpty(documentList) && documentList.size()>0){
            Map<Integer, List<TenderDocument>> collect = documentList.stream().collect(Collectors.groupingBy(TenderDocument::getType));

            //招标文件
            List<TenderDocument> zbDocument = collect.get(1);
            if(BeanUtils.isNotEmpty(zbDocument) && zbDocument.size()>0){
                TenderDocument tenderDocument = zbDocument.get(0);
                tenderDocument.setAccessoryList(accessoryService.getAccessoryBySourceId(tenderDocument.getId()));
                result.setZbDocument(tenderDocument);
            }

            //补遗文件
            List<TenderDocument> byDocument = collect.get(2);
            if(BeanUtils.isNotEmpty(byDocument) && byDocument.size()>0){
                byDocument.stream().forEach(s->{
                    s.setAccessoryList(accessoryService.getAccessoryBySourceId(s.getId()));
                });
                result.setByDocument(byDocument);
            }

        }

        result.setJoinStatus(0);
        if(BeanUtils.isNotEmpty(userId)){
            List<Org> orgList = orgManager.getOrgListByUserId(userId);
            if(BeanUtils.isNotEmpty(orgList) && orgList.size()>0){
                String orgId = orgList.get(0).getId();
                List<String> orgIds = orgList.stream().filter(s -> BeanUtils.isNotEmpty(s.getIsMaster()) && s.getIsMaster() == 1).map(s -> s.getId()).collect(Collectors.toList());
                if(BeanUtils.isNotEmpty(orgIds) && orgIds.size()>0){
                    orgId = orgIds.get(0);
                }

                LambdaQueryWrapper<UserParticipation> userParticipationQW = new LambdaQueryWrapper<>();
                userParticipationQW.eq(UserParticipation::getCompanyId,orgId)
                        .eq(UserParticipation::getNoticeType,1)
                        .eq(UserParticipation::getNoticeId,result.getId())
                        .eq(UserParticipation::getIsDele,0).last("limit 1");
                UserParticipation participation = userParticipationManager.getBaseMapper().selectOne(userParticipationQW);
                if(BeanUtils.isNotEmpty(participation) && BeanUtils.isNotEmpty(participation.getStatus())){
                    result.setJoinStatus(participation.getStatus());
                }
            }

        }

        return result;
    }

    @Override
    public PageList<MatApproval> quoData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("notice.RELEASE_STATUS_", "2", QueryOP.EQUAL);
        queryFilter.addFilter("notice.IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("notice.BID_STATUS_", "3", QueryOP.EQUAL);
        queryFilter.addFilter("part.IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("part.NOTICE_TYPE_", 1, QueryOP.EQUAL);
        queryFilter.addFilter("part.STATUS_", 1, QueryOP.EQUAL);
        queryFilter.addFilter("part.COMPANY_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        queryFilter.addFilter("notice.BIDDING_END_TIME_",LocalDateTime.now(),QueryOP.GREAT_EQUAL);

        IPage<MatApproval> result = baseMapper.getQuoData(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));

        List<MatApproval> records = result.getRecords();
        if(BeanUtils.isNotEmpty(records) && records.size()>0){
            records.stream().forEach(s->{
                //查询报价表是否已报价
                LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
                quoQW.eq(BizBiddingQuotation::getQuotationRounds,s.getQuotationRoundsNum())
                        .eq(BizBiddingQuotation::getNoticeId,s.getId())
                        .eq(BizBiddingQuotation::getNoticeType,1)
                        .eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId());
                if(quotationManager.count(quoQW)>0){
                    s.setIsQuo(1);
                }else {
                    s.setIsQuo(0);
                }

            });
        }

        return new PageList<>(result);
    }

    @Override
    public PageList<MatApproval> quoManageData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        queryFilter.addFilter("RELEASE_STATUS_", "2", QueryOP.EQUAL);

        if(BizUtils.isAdmin(ucFeignService)){
            //1.查询当前公司代采的申请id
            LambdaQueryWrapper<PurchasingApplication> applicationQW = new LambdaQueryWrapper<>();
            applicationQW.select(PurchasingApplication::getId)
                    .eq(PurchasingApplication::getPreparedOrgId,ContextUtil.getCurrentOrgId())
                    .eq(PurchasingApplication::getIsAgencyProcure,1)
                    .eq(PurchasingApplication::getIsDele,"0");
            List<Object> objectList = purchasingApplicationManager.listObjs(applicationQW);
            if(BeanUtils.isNotEmpty(objectList) && objectList.size()>0){
                List<String> applicationId = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());

                //2.查询代采立项id
                QueryWrapper<MatApprovalDetails> noticeIdsQW = new QueryWrapper<>();
                noticeIdsQW.select("distinct NOTICE_ID_")
                        .lambda().in(MatApprovalDetails::getPurchasingApplicationId,applicationId)
                        .eq(MatApprovalDetails::getIsDele,"0");
                List<Object> noticeIdObjs = matApprovalDetailsManager.listObjs(noticeIdsQW);
                if(BeanUtils.isNotEmpty(noticeIdObjs) && noticeIdObjs.size()>0) {
                    List<String> noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                    queryFilter.addFilter("ID_",noticeIds,QueryOP.IN,FieldRelation.OR,"org");
                }

            }

            queryFilter.addFilter("AFFILIATED_ORG_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL, FieldRelation.OR,"org");
            queryFilter.addFilter("PROCURE_ORG_ID_",ContextUtil.getCurrentOrgId(),QueryOP.EQUAL, FieldRelation.OR,"org");

            //查询当前公司报过价的立项
            QueryWrapper<BizBiddingQuotation> quoQW = new QueryWrapper<>();
            quoQW.select("DISTINCT NOTICE_ID_")
                    .lambda().eq(BizBiddingQuotation::getQuotationCompanyId,ContextUtil.getCurrentOrgId())
                    .eq(BizBiddingQuotation::getNoticeType,1);
            List<Object> quoNoticeIdsObj = quotationManager.listObjs(quoQW);
            if(BeanUtils.isNotEmpty(quoNoticeIdsObj) && quoNoticeIdsObj.size()>0){
                List<String> collect = quoNoticeIdsObj.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
                queryFilter.addFilter("ID_",collect,QueryOP.IN, FieldRelation.OR,"org");
            }

        }

        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<MatApproval> bidOpenData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("RELEASE_STATUS_", "2", QueryOP.EQUAL);
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        BizUtils.addFilterByUserOrgAndRole(queryFilter,ucFeignService,"AFFILIATED_ORG_ID_");
        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void openingBid(MatApproval entity) {
        List<ProjectEvaluationExpert> evaluationExpertList = entity.getProjectEvaluationExpertList();
        if(BeanUtils.isNotEmpty(evaluationExpertList) && evaluationExpertList.size()>0){
            //删除原始评标专家
            LambdaQueryWrapper<ProjectEvaluationExpert> evaluationExpertQW = new LambdaQueryWrapper<>();
            evaluationExpertQW.eq(ProjectEvaluationExpert::getProjectApprovalId,entity.getId())
                    .eq(ProjectEvaluationExpert::getProjectApprovalType,1);
            evaluationExpertManager.remove(evaluationExpertQW);

            //保存评标专家
            evaluationExpertList.stream().forEach(s->{
                s.setId(null);
                s.setProjectApprovalId(entity.getId());
                s.setProjectApprovalType(1);
            });
            evaluationExpertManager.saveBatch(evaluationExpertList);
        }

        //生成开标记录
        BizBidOpening bidOpening = new BizBidOpening();
        bidOpening.setOperateType(1);
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(entity.getQuotationRoundsNum());
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(entity.getId());
        bidOpening.setNoticeType(1);
        bidOpening.setNoticeCode(entity.getProjectNumber());
        bidOpening.setOperateUserName(entity.getNoticeTitle());
        bidOpening.setEvaluationMethod(entity.getEvaluationMethod());
        bidOpeningManager.save(bidOpening);

        //更新开标状态为已开标
        Integer noticeStatus = 5;

        //查询立项报价供应商是否满足条件
        LambdaQueryWrapper<BizBiddingQuotation> quoQW = new LambdaQueryWrapper<>();
        quoQW.eq(BizBiddingQuotation::getNoticeId,entity.getId());
        if(quotationManager.count(quoQW)==0){
            //如果报价供应商不满足就流标
            noticeStatus = 8;

            LambdaUpdateWrapper<MatApprovalDetails> approvalDetailUW = new LambdaUpdateWrapper<>();
            approvalDetailUW.set(MatApprovalDetails::getBidStatus,6)
                    .eq(MatApprovalDetails::getNoticeId,entity.getId())
                    .eq(MatApprovalDetails::getIsDele,"0");
            matApprovalDetailsManager.update(approvalDetailUW);
        }

        LambdaUpdateWrapper<MatApproval> approvalUW = new LambdaUpdateWrapper<>();
        approvalUW.set(MatApproval::getBidStatus,noticeStatus)
                .set(BeanUtils.isNotEmpty(entity.getEvaluationMethod()),MatApproval::getEvaluationMethod,entity.getEvaluationMethod())
                .set(MatApproval::getEvaluationStartTime,bidOpening.getOperateTime())
                .eq(MatApproval::getId, entity.getId())
                .eq(MatApproval::getIsDele,"0");
        super.update(approvalUW);

        if(entity.getEvaluationMethod()==1){
            //如果是最低价评标法
            //按物料评标
            if(entity.getEvaluationMode()==1){
                //自动生成评标记录
                EvaVo evaVo = new EvaVo();
                evaVo.setNoticeId(entity.getId());
                evaVo.setNoticeType("1");
                bidEvaluationManager.bidEvaLowestAuto(evaVo);
            }

        }

    }

    @Override
    @Transactional
    public void newRoundQuo(MatApproval entity) {
        MatApproval notice = super.getById(entity.getId());
        BizBidOpening bidOpening = new BizBidOpening();
        Integer roundsNum = BeanUtils.isNotEmpty(notice.getQuotationRoundsNum())?notice.getQuotationRoundsNum():1;
        if(entity.getBidStatus()==3){
            //新一轮报价
            if(notice.getBidStatus()!=5 && notice.getBidStatus()!=6) {
                throw new BaseException("当前项目状态无法发起新一轮报价");
            }
            if(BeanUtils.isNotEmpty(notice.getCalibraStatus()) && notice.getCalibraStatus()!=0) {
                throw new BaseException("已发起定标审批，无法发起新一轮报价");
            }

            notice.setBiddingStartTime(entity.getBiddingStartTime());
            notice.setBiddingEndTime(entity.getBiddingEndTime());
            notice.setQuotationRoundsNum(roundsNum+1);
            if(BeanUtils.isNotEmpty(entity.getNewQuoReason())) {
                notice.setNewQuoReason(entity.getNewQuoReason());
                bidOpening.setRemarks(entity.getNewQuoReason());
            }
            bidOpening.setOperateType(3);
        }else if(entity.getBidStatus()==8){
            if(BeanUtils.isNotEmpty(notice.getCalibraStatus()) && notice.getCalibraStatus()!=0) {
                throw new BaseException("已发起定标审批，无法流标");
            }

            if(BeanUtils.isNotEmpty(entity.getFailBidReason())) {
                notice.setFailBidReason(entity.getFailBidReason());
                bidOpening.setRemarks(entity.getFailBidReason());
            }
            bidOpening.setOperateType(2);
        }
        notice.setBidStatus(entity.getBidStatus());
        super.updateById(notice);

        //生成开标记录
        bidOpening.setOperateTime(LocalDateTime.now());
        bidOpening.setOperateUserId(ContextUtil.getCurrentUserId());
        bidOpening.setOperateUserAccount(ContextUtil.getCurrentUserAccount());
        bidOpening.setOperateUserName(ContextUtil.getCurrentUserName());
        bidOpening.setQuotationRounds(roundsNum);
        bidOpening.setOperateMethod(1);
        bidOpening.setNoticeId(notice.getId());
        bidOpening.setNoticeType(1);
        bidOpening.setNoticeCode(notice.getProjectNumber());
        bidOpening.setOperateUserName(notice.getNoticeTitle());
        bidOpening.setEvaluationMethod(notice.getEvaluationMethod());
        bidOpeningManager.save(bidOpening);
    }

    @Override
    public PageList<MatApproval> bidEvaData(QueryFilter<MatApproval> queryFilter) {
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);
        List<String> idList = baseMapper.queryIds(convert2Wrapper(queryFilter,
                currentModelClass()));

        if(BeanUtils.isEmpty(idList) || idList.size()<=0){
            return new PageList<>(convert2IPage(queryFilter.getPageBean()));
        }

//        if(BizUtils.isAdmin(ucFeignService)){
            //1.查询当前账号评标的立项
            QueryWrapper<ProjectEvaluationExpert> evaExpertQW = new QueryWrapper<>();
            evaExpertQW.select("distinct PROJECT_APPROVAL_ID_")
                    .lambda().eq(ProjectEvaluationExpert::getAccount,ContextUtil.getCurrentUserAccount())
                    .eq(ProjectEvaluationExpert::getProjectApprovalType,"1")
                    .in(ProjectEvaluationExpert::getProjectApprovalId,idList)
                    .eq(ProjectEvaluationExpert::getIsDele,"0");
            List<Object> noticeIdObjs = evaluationExpertManager.listObjs(evaExpertQW);
            if(BeanUtils.isEmpty(noticeIdObjs) || noticeIdObjs.size()<=0) {
                return new PageList<>();
            }
            List<String> noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());

            queryFilter.addFilter("ID_",noticeIds,QueryOP.IN);
//        }

        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    @Transactional
    public void releaseWinBidNotice(String id) throws Exception {
        MatApproval approval = super.getById(id);
        //1.更新立项公告项目状态
        approval.setBidStatus(11);
        super.updateById(approval);

        //2.查询定标记录生成到成交通知表
        LambdaQueryWrapper<Calibration> calibraQW = new LambdaQueryWrapper<>();
        calibraQW.eq(Calibration::getNoticeId,id)
                .eq(Calibration::getNoticeType,1)
                .eq(Calibration::getIsDele,"0");
        List<Calibration> calibraList = calibraManager.list(calibraQW);
        if(BeanUtils.isNotEmpty(calibraList) && calibraList.size()>0){

            List<BizWinBiddingNoticeDetaile> winNoticeDetailList = new ArrayList<>();
            for(Calibration ca : calibraList){
                BizWinBiddingNotice winNotice = new BizWinBiddingNotice();
                BeanUtils.copyNotNullProperties(winNotice,ca);
                winNotice.setId(null);
//                winNotice.setCalibrationId(ca.getId());
                winNotice.setProcureOrgId(approval.getProcureOrgId());
                winNotice.setProcureOrgCode(approval.getProcureOrgCode());
                winNotice.setProcureOrgName(approval.getProcureOrgName());
                winNotice.setSendTime(LocalDateTime.now());
                winNotice.setStatus(1);
                winBidNoticeManager.save(winNotice);

                LambdaQueryWrapper<CalibrationDetail> caDetailQW = new LambdaQueryWrapper<>();
                caDetailQW.eq(CalibrationDetail::getCalibrationId,ca.getId());
                List<CalibrationDetail> caDetailList = calibraDetailManager.list(caDetailQW);
                if(BeanUtils.isNotEmpty(caDetailList) && caDetailList.size()>0){
                    for(CalibrationDetail caDetail : caDetailList){
                        BizWinBiddingNoticeDetaile winNoticeDetail = new BizWinBiddingNoticeDetaile();
                        BeanUtils.copyNotNullProperties(winNoticeDetail,caDetail);
                        winNoticeDetail.setId(null);
//                        winNoticeDetail.setCalibrationDetailId(caDetail.getId());
                        winNoticeDetail.setWinNoticeId(winNotice.getId());
                        winNoticeDetail.setApplicationMethod(approval.getProcureType());
                        winNoticeDetail.setIsTax(approval.getIsTax());
                        winNoticeDetail.setStatus(1);
                        winNoticeDetailList.add(winNoticeDetail);
                    }
                }

            }

            if(winNoticeDetailList.size()>0) {
                winBidNoticeDetailManager.saveBatch(winNoticeDetailList);
            }

        }

    }

    @Override
    public PageList<MatApproval> bidEvaAgencyData(QueryFilter<MatApproval> queryFilter) {
        //1.查询当前公司代采的申请id
        LambdaQueryWrapper<PurchasingApplication> applicationQW = new LambdaQueryWrapper<>();
        applicationQW.select(PurchasingApplication::getId)
                .eq(PurchasingApplication::getPreparedOrgId,ContextUtil.getCurrentOrgId())
                .eq(PurchasingApplication::getIsAgencyProcure,1)
                .eq(PurchasingApplication::getIsDele,"0");
        List<Object> objectList = purchasingApplicationManager.listObjs(applicationQW);

        if(BeanUtils.isEmpty(objectList) || objectList.size()<=0){
            return new PageList<>(new ArrayList<MatApproval>());
        }
        List<String> applicationId = objectList.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());

        //2.查询代采立项id
        QueryWrapper<MatApprovalDetails> noticeIdsQW = new QueryWrapper<>();
        noticeIdsQW.select("distinct NOTICE_ID_")
                .lambda().in(MatApprovalDetails::getPurchasingApplicationId,applicationId)
                .eq(MatApprovalDetails::getIsDele,"0");
        List<Object> noticeIdObjs = matApprovalDetailsManager.listObjs(noticeIdsQW);
        if(BeanUtils.isEmpty(noticeIdObjs) || noticeIdObjs.size()<=0) {
            return new PageList<>(new ArrayList<MatApproval>());
        }

        List<String> noticeIds = noticeIdObjs.stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
        queryFilter.addFilter("ID_",noticeIds,QueryOP.IN);
        queryFilter.addFilter("IS_DELE_", "0", QueryOP.EQUAL);

        IPage<MatApproval> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public Integer getNoticeTypeById(String id) {
        if(BeanUtils.isEmpty(super.getById(id))){
            return 2;
        }
        return 1;
    }

}
