package com.artfess.cgpt.purchasing.manager.impl;

import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.contract.manager.BizContractManager;
import com.artfess.cgpt.contract.model.BizContract;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderDetailManager;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrder;
import com.artfess.cgpt.purchasing.dao.BizPurchaseOrderDao;
import com.artfess.cgpt.purchasing.manager.BizPurchaseOrderManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.purchasing.model.BizPurchaseOrderDetail;
import com.artfess.cgpt.universal.model.Accessory;
import com.artfess.cgpt.universal.service.AccessoryService;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.lang.reflect.Array;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

/**
 * 采购订单表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-27
 */
@Service
public class BizPurchaseOrderManagerImpl extends BaseManagerImpl<BizPurchaseOrderDao, BizPurchaseOrder> implements BizPurchaseOrderManager {

    @Resource
    private BizPurchaseOrderDetailManager purchaseOrderDetailManager;
    @Resource
    private AccessoryService accessoryService;
    @Resource
    private SystemConfigFeignService systemConfigFeignService;
    @Autowired
    private BizContractManager contractManager;

    @Override
    public BizPurchaseOrder getDetailById(String id) {
        BizPurchaseOrder order = this.getById(id);
        List<BizPurchaseOrderDetail> details = purchaseOrderDetailManager.getListByOrderId(id);
        List<Accessory> accessories = accessoryService.getAccessoryBySourceId(id);

        order.setDetailsList(details);
        order.setAccessoryList(accessories);
        return order;
    }


    @Override
    @Transactional
    public void saveVo(BizPurchaseOrder entity) {
        List<BizPurchaseOrderDetail> detailsList = entity.getDetailsList();
        List<Accessory> accessoryList = entity.getAccessoryList();
        List<String> contractIdList = entity.getContractIdList();

        if(BeanUtils.isEmpty(entity.getId())){
            //新增
            entity.setOrderCreatedate(LocalDateTime.now());
            if(BeanUtils.isEmpty(entity.getOrderCode())){
                String bacthNum = BizUtils.getNextSerialNumber(systemConfigFeignService, "cgpt_cgdd");
                entity.setOrderCode(bacthNum);
            }
        }else {
            //更新

            purchaseOrderDetailManager.delByOrderId(entity.getId());
            accessoryService.removeBySourceId(entity.getId());

            //还原关联合同订单状态
            LambdaUpdateWrapper<BizContract> contractUW = new LambdaUpdateWrapper<>();
            contractUW.set(BizContract::getOrderId,null)
                    .set(BizContract::getOrderStatus,0)
                    .eq(BizContract::getOrderId,entity.getId())
                    .eq(BizContract::getIsDele,"0");
            contractManager.update(contractUW);
        }

        if(BeanUtils.isEmpty(entity.getStatus())){
            entity.setStatus(1);
        }

        this.saveOrUpdate(entity);

        if(BeanUtils.isNotEmpty(detailsList) && detailsList.size()>0){
            detailsList.stream().forEach(s->{
                s.setOrderId(entity.getId());
                s.setOrderCode(entity.getOrderCode());
            });
            purchaseOrderDetailManager.saveOrUpdateBatch(detailsList);
        }

        if(BeanUtils.isNotEmpty(accessoryList) && accessoryList.size()>0){
            accessoryList.forEach(s->s.setSourceId(entity.getId()));
            accessoryService.saveBatch(accessoryList);
        }

        if(BeanUtils.isNotEmpty(contractIdList) && contractIdList.size()>0){
            LambdaUpdateWrapper<BizContract> contractUW = new LambdaUpdateWrapper<>();
            contractUW.set(BizContract::getOrderId,entity.getId())
                    .set(BizContract::getOrderStatus,1)
                    .in(BizContract::getId,contractIdList)
                    .eq(BizContract::getIsDele,"0");
            contractManager.update(contractUW);
        }

    }

    @Override
    public PageList<BizPurchaseOrder> queryAllByPage(QueryFilter<BizPurchaseOrder> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        PageList<BizPurchaseOrder> pageList = this.query(queryFilter);

//        for (BizPurchaseOrder order : pageList.getRows()) {
//            List<BizPurchaseOrderDetail> details=  purchaseOrderDetailManager.getListByOrderId(order.getId());
//            List<Accessory> accessories = accessoryService.getAccessoryBySourceId(order.getId());
//            order.setDetailsList(details);
//            order.setAccessoryList(accessories);
//        }
        return pageList;
    }


    @Override
    public void removeData(List<String> ids) {
        LambdaQueryWrapper<BizPurchaseOrderDetail> orderDetailQW = new LambdaQueryWrapper<>();
        orderDetailQW.in(BizPurchaseOrderDetail::getOrderId,ids);
        purchaseOrderDetailManager.remove(orderDetailQW);

        accessoryService.removeBySourceIds(ids);

        //还原关联合同订单状态
        LambdaUpdateWrapper<BizContract> contractUW = new LambdaUpdateWrapper<>();
        contractUW.set(BizContract::getOrderId,null)
                .set(BizContract::getOrderStatus,0)
                .in(BizContract::getOrderId,ids)
                .eq(BizContract::getIsDele,"0");
        contractManager.update(contractUW);

        super.removeByIds(ids);
    }

    /**
     * 修改状态
     * @param ids
     * @param status
     */
    @Override
    @Transactional
    public void confirmOrder(String ids,String status) {
        List<String> idList = Arrays.asList(ids.split(","));
        LambdaUpdateWrapper<BizPurchaseOrder> uw = new LambdaUpdateWrapper<>();
        uw.set(BizPurchaseOrder::getStatus,status)
                .set(BizPurchaseOrder::getOrderLastchgdate,LocalDateTime.now())
                .in(BizPurchaseOrder::getId,idList)
                .eq(BizPurchaseOrder::getIsDele,"0");
        super.update(uw);
    }

    @Override
    public PageList<BizPurchaseOrder> pageMatCompanyGroup(QueryFilter<BizPurchaseOrder> queryFilter) {
        queryFilter.addFilter("IS_DELE_", 0, QueryOP.EQUAL);
        IPage<BizPurchaseOrder> result = baseMapper.pageMatCompanyGroup(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
