package com.artfess.cgpt.purchasing.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.model.ClarifyQuestions;
import com.artfess.cgpt.purchasing.model.MatApproval;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/3/27 17:44
 */
public interface ClarifyQuestionsManager extends BaseManager<ClarifyQuestions> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ClarifyQuestions> queryAllByPage(QueryFilter<ClarifyQuestions> queryFilter);

    /**
     * 分页查询所有数据（包含回答）
     * @param queryFilter
     * @return
     */
    PageList<ClarifyQuestions> pageAndAnswer(QueryFilter<ClarifyQuestions> queryFilter);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(ClarifyQuestions entity);

}
