package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.purchasing.manager.TenderDocumentManager;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.TenderDocument;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:招标/补遗文件表
 * @Author: Rong Tao
 * @Date: 2024/5/21 18:45
 */
@RestController
@RequestMapping("/tenderDocument/v1/")
@Api(tags="招标/补遗文件表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class TenderDocumentController extends BaseController<TenderDocumentManager, TenderDocument> {

    @PostMapping("/queryConfirmStatus")
    @ApiOperation(value = "M-判断当前供应商是否确认文件")
    public CommonResult queryConfirmStatus(@RequestBody QueryFilter<TenderDocument> queryFilter) {
        Boolean result = baseService.queryConfirmStatus(queryFilter);
        return new CommonResult<>(result, result?"已全部确认":"未全部确认");
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<TenderDocument>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<TenderDocument> queryFilter) {
        PageList<TenderDocument> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/pageAccessory")
    @ApiOperation(value = "M-分页查询所有数据（带附件）")
    public CommonResult<PageList<TenderDocument>> pageAccessory(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<TenderDocument> queryFilter) {
        PageList<TenderDocument> result = baseService.pageAccessory(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/modifyReleaseStatus")
    @ApiOperation(value = "M-修改发布状态")
    public CommonResult modifyReleaseStatus(@RequestParam("ids") String ids,
                                            @RequestParam("status") String status){
        baseService.modifyReleaseStatus(ids,status);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/removeByIds")
    @ApiOperation(value = "M-根据id集合删除数据")
    public CommonResult removeByIds(@RequestBody List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/uploadByDoc")
    @ApiOperation(value = "M-上传补遗文件")
    public CommonResult uploadByDoc(@RequestBody List<TenderDocument> docList){
        baseService.uploadByDoc(docList);
        return new CommonResult<>(true,"操作成功");
    }

}
