package com.artfess.cgpt.purchasing.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.purchasing.manager.PurchasingRulesManager;
import com.artfess.cgpt.purchasing.model.PurchasingApplication;
import com.artfess.cgpt.purchasing.model.PurchasingRules;
import com.artfess.uc.api.impl.util.ContextUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/5/21 10:38
 */
@RestController
@RequestMapping("/purchasingApplicationRules/v1/")
@Api(tags="采购审批规则管理")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingRulesController extends BaseController<PurchasingRulesManager, PurchasingRules> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<PurchasingRules>> queryAllByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingRules> queryFilter) {
        PageList<PurchasingRules> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<PurchasingRules>> queryByPage(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<PurchasingRules> queryFilter) {
        if(!ContextUtil.getCurrentUserAccount().equals("admin")){
            queryFilter.addFilter("PROCURE_ORG_ID_", ContextUtil.getCurrentOrgId(), QueryOP.EQUAL);
        }
        PageList<PurchasingRules> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询数据")
    public CommonResult<PurchasingRules> getDataById(@RequestParam("id") String id) {
        PurchasingRules result = baseService.getDetailById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新数据")
    public CommonResult saveOrUpdate(@RequestBody PurchasingRules entity){
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true,"操作成功");
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeDataByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

//    @PostMapping("/isAuditing")
//    @ApiOperation(value = "M-是否需要走流程")
//    public CommonResult isAuditing(@RequestParam("orgId")String orgId,@RequestParam("menuAlia")String menuAlia) {
//        baseService.isAuditing(orgId,menuAlia);
//        return new CommonResult<>(true, "删除成功");
//    }

}
