package com.artfess.cgpt.purchasing.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.purchasing.model.PurchasingApplicationQualification;
import com.artfess.cgpt.purchasing.manager.PurchasingApplicationQualificationManager;

import java.util.List;

/**
 * 采购申请_资质标签关联表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-09
 */
@RestController
@RequestMapping("/bizPurchasingApplicationQualification/v1/")
@Api(tags="采购单位")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class PurchasingApplicationQualificationController extends BaseController<PurchasingApplicationQualificationManager, PurchasingApplicationQualification> {
    @PostMapping("/page")
    @ApiOperation(value = "S-分页查询数据")
    public CommonResult<PageList<PurchasingApplicationQualification>> queryAllByPage(@ApiParam(name="queryfilter",value = "通用查询器")@RequestBody QueryFilter<PurchasingApplicationQualification> queryFilter){
        PageList<PurchasingApplicationQualification> result=baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "S-查询详情")
    public CommonResult<PurchasingApplicationQualification> selectOne(@RequestParam String id){
        PurchasingApplicationQualification result=baseService.getById(id);
        return new CommonResult<>(true,"查询成功",result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids){
        baseService.removeByIds(ids);
        return new CommonResult<>(true,"删除成功");
    }

    @PostMapping("/save")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult save(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody PurchasingApplicationQualification entity) {
        String message = "操作成功";
        baseService.saveOrUpdate(entity);

        return new CommonResult<>(true, message);
    }
}
