package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/2 9:58
 */
@ApiModel(value="UserParticipationQualificationLabel对象", description="参与报名资质信息关联表")
@TableName("biz_user_participation_qualification_label")
@Data
public class UserParticipationQualificationLabel extends BizNoModel<UserParticipationQualificationLabel> {


    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "参与报名ID（关联参与报名表ID）")
    @TableField("USER_PARTICIPATION_ID_")
    private String userParticipationId;

    @ApiModelProperty(value = "资质库ID（关联资质库表ID）")
    @TableField("QUALIFICATION_LABEL_ID_")
    private String qualificationLabelId;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

}
