package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:服务项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/24 15:50
 */
@ApiModel(value="ServiceProjectDetail对象", description="服务项目明细表")
@TableName("biz_service_project_detail")
@Data
public class ServiceProjectDetail extends BizNoModel<ServiceProjectDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目台账表ID")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目编号（关联项目库编号）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "父级ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "基础扩展（服务范围）")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展（服务内容）")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "金额（万元）")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "服务开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "服务结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "责任人ID")
    @TableField("PERSON_LIABLE_ID_")
    private String personLiableId;

    @ApiModelProperty(value = "责任人姓名")
    @TableField("PERSON_LIABLE_NAME_")
    private String personLiableName;

    @ApiModelProperty(value = "责任人联系方式")
    @TableField("PERSON_LIABLE_PHONE_")
    private String personLiablePhone;

}