package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:项目基本信息明细表
 * @Author: Rong Tao
 * @Date: 2024/3/27 18:00
 */
@ApiModel(value="ProjectInfoDetail对象", description="项目基本信息明细表")
@TableName("biz_project_info_detail")
@Data
public class ProjectInfoDetail extends BizNoModel<ProjectInfoDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目基本信息表ID")
    @TableField("PROJECT_INFO_ID_")
    private String projectInfoId;

    @ApiModelProperty(value = "项目库ID（关联项目台账表ID）")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "计划编号")
    @TableField("PLAN_CODE_")
    private String planCode;

    @ApiModelProperty(value = "明细类型（1.服务，2.工程）")
    @TableField("DETAIL_TYPE_")
    private Integer detailType;

    @ApiModelProperty(value = "对应明细id（如服务类则是服务项目明细表id）")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "物料分类编号，关联物料分类CODE")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编号")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "平台物料编号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "名称（服务类：名称，工程类：项目或费用名称）")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展（服务范围）")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展（服务内容）")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "计划价格（合计金额）")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "送货地址")
    @TableField("UNLOAD_ADDRESS")
    private String unloadAddress;

    @ApiModelProperty(value = "税率")
    @TableField("TAX_RATE_")
    private Integer taxRate;

    @ApiModelProperty(value = "是否含税价（1：含税，2：不含税）")
    @TableField("IS_TAX_")
    private Integer isTax;

    @ApiModelProperty(value = "合同匹配完成状态（0.未完成，1.完成），默认0")
    @TableField("PUR_CONTRACT_STATUS_")
    private Integer purContractStatus;

    @ApiModelProperty(value = "服务开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "服务结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField("BUILDING_AREA_")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField("CONSTRUCTION_ENGINEERING_")
    private BigDecimal constructionEngineering;

    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField("EQUIPMENT_PROCUREMENT_")
    private BigDecimal equipmentProcurement;

    @ApiModelProperty(value = "其他费用(万元)")
    @TableField("OTHER_EXPENSES_")
    private BigDecimal otherExpenses;

    @ApiModelProperty(value = "企业补充说明")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "最高限价，默认0")
    @TableField("MAXIMUM_PRICE_LIMIT_")
    private BigDecimal maximumPriceLimit;

    @ApiModelProperty(value = "承兑时间（1·12个月）")
    @TableField("ACCEPTANCE_TIME_")
    private Integer acceptanceTime;

    @ApiModelProperty(value = "挂账时间（1·12个月）")
    @TableField("PENDING_TIME_")
    private Integer pendingTime;

    @ApiModelProperty(value = "设备分类（1.下料设备，2.铆焊设备，3.机加设备，4.热表设备，5.装配设备，6.检测设备，7.其他设备）")
    @TableField("EQUIPMENT_CLASSIFICATION_")
    private Integer equipmentClassification;

    @ApiModelProperty(value = "技术要求（设备使用）")
    @TableField("TECHNICAL_REQUIREMENT_")
    private String technicalRequirement;

    @ApiModelProperty(value = "不含税单价（元）")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "不含税总额（元）")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "含税单价（元）")
    @TableField("TAX_INPRICE_")
    private BigDecimal taxInprice;

    @ApiModelProperty(value = "含税总额（元）")
    @TableField("TAX_INVALUE_")
    private BigDecimal taxInvalue;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

    @ApiModelProperty(value = "状态（1：未立项，2：已立项，3：流标，4：已签订合同），默认1")
    @TableField("STATUS_")
    private Integer status;

}
