package com.artfess.cgpt.project.model;

import com.artfess.base.entity.BizModel;
import com.artfess.base.entity.BizNoModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * @Description:工程项目明细表
 * @Author: Rong Tao
 * @Date: 2024/5/24 15:43
 */
@ApiModel(value="EngineeringProjectDetail对象", description="工程项目明细表")
@TableName("biz_engineering_project_detail")
@Data
public class EngineeringProjectDetail extends BizNoModel<EngineeringProjectDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "项目台账表ID")
    @TableField("PROJECT_LEDGER_ID_")
    private String projectLedgerId;

    @ApiModelProperty(value = "项目编号（关联项目库编号）")
    @TableField("PROJECT_LEDGER_CODE_")
    private String projectLedgerCode;

    @ApiModelProperty(value = "父级ID")
    @TableField("PARENT_ID_")
    private String parentId;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "规格型号（图号）")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "项目或费用名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "建筑面积（平方米）")
    @TableField("BUILDING_AREA_")
    private BigDecimal buildingArea;

    @ApiModelProperty(value = "建筑工程及公用系统(万元)")
    @TableField("CONSTRUCTION_ENGINEERING_")
    private BigDecimal constructionEngineering;

    @ApiModelProperty(value = "设备购置及安装(万元)")
    @TableField("EQUIPMENT_PROCUREMENT_")
    private BigDecimal equipmentProcurement;

    @ApiModelProperty(value = "其他费用(万元)")
    @TableField("OTHER_EXPENSES_")
    private BigDecimal otherExpenses;

    @ApiModelProperty(value = "合计(万元)")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "其中：外币(万元)")
    @TableField("FOREIGN_CURRENCY_")
    private BigDecimal foreignCurrency;

    @ApiModelProperty(value = "开始时间")
    @TableField("SERVICE_START_TIME_")
    private LocalDate serviceStartTime;

    @ApiModelProperty(value = "结束时间")
    @TableField("SERVICE_END_TIME_")
    private LocalDate serviceEndTime;

    @ApiModelProperty(value = "比例（整数）")
    @TableField("PROPORTION_")
    private Integer proportion;

    @ApiModelProperty(value = "项目状态（1.立项、2.在建、3.竣工 、4.终止）")
    @TableField("PROJECT_STATUS_")
    private Integer projectStatus;

    @ApiModelProperty(value = "项目描述")
    @TableField("PROJECT_DESCRIPT_")
    private String projectDescript;

    @ApiModelProperty(value = "责任人ID")
    @TableField("PERSON_LIABLE_ID_")
    private String personLiableId;

    @ApiModelProperty(value = "责任人姓名")
    @TableField("PERSON_LIABLE_NAME_")
    private String personLiableName;

    @ApiModelProperty(value = "责任人联系方式")
    @TableField("PERSON_LIABLE_PHONE_")
    private String personLiablePhone;

    @ApiModelProperty(value = "备注")
    @TableField("REMARK_")
    private String remark;

}
