package com.artfess.cgpt.project.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.dao.UserParticipationQualificationLabelDao;
import com.artfess.cgpt.project.manager.UserParticipationQualificationLabelManager;
import com.artfess.cgpt.project.model.UserParticipationQualificationLabel;
import com.artfess.cgpt.qualification.model.BizQualificationLabel;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/7/2 10:02
 */
@Service
public class UserParticipationQualificationLabelManagerImpl extends BaseManagerImpl<UserParticipationQualificationLabelDao,UserParticipationQualificationLabel> implements UserParticipationQualificationLabelManager {

    @Override
    public PageList<UserParticipationQualificationLabel> queryAllByPage(QueryFilter<UserParticipationQualificationLabel> queryFilter) {
        IPage<UserParticipationQualificationLabel> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public PageList<BizQualificationLabel> queryQualificationPage(QueryFilter<UserParticipationQualificationLabel> queryFilter) {
        IPage<BizQualificationLabel> result = baseMapper.queryQualificationPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
