package com.artfess.cgpt.project.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.UserParticipation;
import com.artfess.base.manager.BaseManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;

import java.util.List;

/**
 * 参与报名表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
public interface UserParticipationManager extends BaseManager<UserParticipation> {

    /**
     * 获取成交未退款数据
     * @param
     * @return
     */
    List<UserParticipation> getNoRefundData();

    /**
     * 查询列表（不加租户过滤）
     * @param wrapper
     * @return
     */
    List<UserParticipation> queryList(Wrapper<UserParticipation> wrapper);

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<UserParticipation> queryAllByPage(QueryFilter<UserParticipation> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    UserParticipation getDataById(String id);

    /**
     * 分页查询当前公司数据
     * @param queryFilter
     * @return
     */
    PageList<UserParticipation> queryByPage(QueryFilter<UserParticipation> queryFilter);

    /**
     * 分页查询所有数据及投标情况
     * @param queryFilter
     * @return
     */
    PageList<UserParticipation> pageRegistraAndBid(QueryFilter<UserParticipation> queryFilter);

    /**
     * 参与（无资质）
     * @param entity
     */
    void participate(UserParticipation entity);

    /**
     * 参与（有资质）
     * @param entity
     */
    String qualificationsParticipate(UserParticipation entity);

    /**
     * 修改参与状态
     * @param ids
     * @param status
     */
    void modifyStatus(String ids,String status);

    /**
     * 根据立项id修改当前组织参与状态
     * @param noticeIds
     * @param status
     */
    void modifyStatusByNoticeId(String noticeIds,String status);

    /**
     * 退还成交供应商保证金
     */
    void refundWinBidBond();

}
