package com.artfess.cgpt.project.manager;

import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.base.manager.BaseManager;

import java.util.List;

/**
 * 项目基本信息表 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-10
 */
public interface ProjectInfoManager extends BaseManager<ProjectInfo> {

    /**
     * 分页查询所有数据
     * @param queryFilter
     * @return
     */
    PageList<ProjectInfo> queryAllByPage(QueryFilter<ProjectInfo> queryFilter);

    /**
     * 分页查询当前公司数据
     * @param queryFilter
     * @return
     */
    PageList<ProjectInfo> queryByPage(QueryFilter<ProjectInfo> queryFilter);

    /**
     * 根据id查询详情
     * @param id
     * @return
     */
    ProjectInfo getDataById(String id);

    /**
     * 批量删除
     * @param ids
     */
    void removeByIds(List<String> ids);

    /**
     * 保存或更新数据
     * @param entity
     */
    void saveOrUpdateEntity(ProjectInfo entity);

}
