package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.ProjectLedgerManager;
import com.artfess.cgpt.project.model.ProjectInfo;
import com.artfess.cgpt.project.model.ProjectLedger;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:项目台账表
 * @Author: Rong Tao
 * @Date: 2024/5/21 16:16
 */
@RestController
@RequestMapping("/projectLedger/v1/")
@Api(tags="项目台账表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectLedgerController extends BaseController<ProjectLedgerManager, ProjectLedger> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ProjectLedger>> queryAllByPage(@ApiParam(name = "queryFilter", value = "通用查询器") @RequestBody QueryFilter<ProjectLedger> queryFilter) {
        PageList<ProjectLedger> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "M-保存或更新")
    public CommonResult saveOrUpdate(@RequestBody ProjectLedger entity) {
        baseService.saveOrUpdateEntity(entity);
        return new CommonResult<>(true, "操作成功");
    }

    @PostMapping("/remove")
    @ApiOperation(value = "M-批量删除")
    public CommonResult remove(@RequestBody List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/getDataById")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<ProjectLedger> getDataById(@RequestParam("id") String id) {
        ProjectLedger result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

}
