package com.artfess.cgpt.project.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cgpt.project.manager.ProjectApprovalPayManager;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.project.model.ProjectApprovalPay;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description:
 * @Author: Rong Tao
 * @Date: 2024/8/27 18:32
 */
@RestController
@RequestMapping("/projectApprovalPay/v1/")
@Api(tags="项目采购立项付款信息表")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectApprovalPayController extends BaseController<ProjectApprovalPayManager, ProjectApprovalPay> {

    @PostMapping("/pageAll")
    @ApiOperation(value = "M-分页查询所有数据")
    public CommonResult<PageList<ProjectApprovalPay>> queryAllByPage(@RequestBody QueryFilter<ProjectApprovalPay> queryFilter) {
        PageList<ProjectApprovalPay> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
