package com.artfess.cgpt.project.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.*;
import com.artfess.base.util.BeanUtils;
import com.artfess.cgpt.bidding.model.QuotationTemplateDetail;
import com.artfess.cgpt.project.model.ProjectApproval;
import com.artfess.cgpt.purchasing.model.MatApproval;
import com.artfess.cgpt.purchasing.model.MatApprovalDetails;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.web.bind.annotation.*;
import com.artfess.base.controller.BaseController;
import com.artfess.cgpt.project.model.ProjectApprovalDetails;
import com.artfess.cgpt.project.manager.ProjectApprovalDetailsManager;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;

/**
 * 项目采购立项明细表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-11
 */
@RestController
@RequestMapping("/projectApprovalDetails/v1/")
@Api(tags="项目采购立项明细")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class ProjectApprovalDetailsController extends BaseController<ProjectApprovalDetailsManager, ProjectApprovalDetails> {

    @PostMapping("/page")
    @ApiOperation(value = "M-分页查询数据")
    public CommonResult<PageList<ProjectApprovalDetails>> queryAllByPage(@RequestBody QueryFilter<ProjectApprovalDetails> queryFilter) {
        PageList<ProjectApprovalDetails> result = baseService.queryAllByPage(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/selectOne")
    @ApiOperation(value = "M-根据id查询详情")
    public CommonResult<ProjectApprovalDetails> selectOne(@RequestParam("id") String id) {
        ProjectApprovalDetails result = baseService.getDataById(id);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/remove")
    @ApiOperation(value = "S-批量删除")
    public CommonResult remove(@RequestParam List<String> ids) {
        baseService.removeByIds(ids);
        return new CommonResult<>(true, "删除成功");
    }

    @PostMapping("/saveOrUpdate")
    @ApiOperation(value = "S-添加或修改")
    public CommonResult saveOrUpdate(@RequestBody ProjectApprovalDetails entity) {
        baseService.saveOrUpdate(entity);
        return new CommonResult<>(true, "添加成功");
    }

    @PostMapping("/quoData")
    @ApiOperation(value = "M-报价明细")
    public CommonResult<ProjectApproval> quoData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ProjectApprovalDetails> queryFilter) {
        ProjectApproval result = baseService.quoData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/quoManageData")
    @ApiOperation(value = "M-报价管理-明细")
    public CommonResult<ProjectApproval> quoManageData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ProjectApprovalDetails> queryFilter) {
        ProjectApproval result = baseService.quoManageData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    @PostMapping("/bidOpenManageData")
    @ApiOperation(value = "M-开票管理-报价明细")
    public CommonResult<PageList<ProjectApprovalDetails>> bidOpenManageData(@ApiParam(name = "queryfilter", value = "通用查询器") @RequestBody QueryFilter<ProjectApprovalDetails> queryFilter) {
        PageList<ProjectApprovalDetails> result = baseService.bidOpenManageData(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

    /**
     * 导出报价模版到Excel
     * @param queryFilter 通用查询器
     * @param response 响应对象
     * @return 通用结果
     * @throws IOException IO异常
     */
    @PostMapping("/exportTemplateToExcel")
    @ApiOperation(value = "M-导出报价模版到Excel",notes = "参数说明：和查询参数一样")
    public CommonResult exportTemplateToExcel (@RequestBody QueryFilter<ProjectApprovalDetails> queryFilter, HttpServletResponse response) throws Exception {
        baseService.exportTemplateToExcel(queryFilter,response);
        return new CommonResult<>("导出成功");
    }

    /**
     * 根据Excel文件转换数据（报价模版导入）
     * @param file Excel文件
     */
    @PostMapping("/excelTemplateToData")
    @ApiOperation(value = "M-根据Excel文件转换数据（报价模版导入）")
    public CommonResult<List<Map<String, String>>> excelTemplateToData(@RequestParam("file") MultipartFile file) {
        List<Map<String, String>> result = baseService.excelTemplateToData(file);
        return new CommonResult<>(true,"操作成功",result);
    }

    @PostMapping("/pageEvaDetail")
    @ApiOperation(value = "M-评标管理-分页查询所有明细数据（带评标标识）")
    public CommonResult<PageList<ProjectApprovalDetails>> pageEvaDetail(@RequestBody QueryFilter<ProjectApprovalDetails> queryFilter) {
        PageList<ProjectApprovalDetails> result = baseService.pageEvaDetail(queryFilter);
        return new CommonResult<>(true, "查询成功", result);
    }

}
