package com.artfess.cgpt.out.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 销售单表有附件
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-03-20
 */
@ApiModel(value="BizOutManifest对象", description="销售单表有附件")
public class BizOutManifest extends BaseModel<BizOutManifest> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "ID主键")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "批次号，自动生成（格式：yyyymmdd00001，按天自动增长）")
    @TableField("OUT_MANIFEST_NUM_")
    private String outManifestNum;

    @ApiModelProperty(value = "发货总金额")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "交易服务费")
    @TableField("TRANSACTION_SERVICE_FEE")
    private BigDecimal transactionServiceFee;

    @ApiModelProperty(value = "合同ID，关联合同表ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    @ApiModelProperty(value = "合同名称")
    @TableField("CONTRACT_NAME_")
    private String contractName;

    @ApiModelProperty(value = "发货人ID")
    @TableField("OUT_MANIFEST_USER_ID_")
    private String outManifestUserId;

    @ApiModelProperty(value = "发货人姓名")
    @TableField("OUT_MANIFEST_USER_NAME_")
    private String outManifestUserName;

    @ApiModelProperty(value = "发货人联系方式")
    @TableField("OUT_MANIFEST_USER_PHONE_")
    private String outManifestUserPhone;

    @ApiModelProperty(value = "发货人所属公司ID")
    @TableField("OUT_MANIFEST_COMPANY_ID_")
    private String outManifestCompanyId;

    @ApiModelProperty(value = "发货人所属公司名称")
    @TableField("OUT_MANIFEST_COMPANY_NAME_")
    private String outManifestCompanyName;

    @ApiModelProperty(value = "发货时间")
    @TableField("OUT_MANIFEST_DATE_")
    private LocalDate outManifestDate;

    @ApiModelProperty(value = "发货地址")
    @TableField("OUT_MANIFEST_ADDRESS_")
    private String outManifestAddress;

    @ApiModelProperty(value = "收货人ID（收货确认时填入）")
    @TableField("IN_MANIFEST_USER_ID_")
    private String inManifestUserId;

    @ApiModelProperty(value = "收货人姓名（收货确认时填入）")
    @TableField("IN_MANIFEST_USER_NAME_")
    private String inManifestUserName;

    @ApiModelProperty(value = "收货人联系方式")
    @TableField("IN_MANIFEST_USER_PHONE_")
    private String inManifestUserPhone;

    @ApiModelProperty(value = "收货人所属公司ID")
    @TableField("IN_MANIFEST_COMPANY_ID_")
    private String inManifestCompanyId;

    @ApiModelProperty(value = "收货人所属公司名称")
    @TableField("IN_MANIFEST_COMPANY_NAME_")
    private String inManifestCompanyName;

    @ApiModelProperty(value = "收货时间")
    @TableField("IN_MANIFEST_DATE_")
    private LocalDate inManifestDate;

    @ApiModelProperty(value = "状态（1：未发货 ，2：已发货，3： 已收货，4：已结算）")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建人单位ID")
    @TableField("CREATE_COMPANY_ID_")
    private String createCompanyId;

    @ApiModelProperty(value = "创建人单位名称")
    @TableField("CREATE_COMPANY_NAME_")
    private String createCompanyName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人单位名称")
    @TableField("UPDATE_COMPANY_NAME_")
    private String updateCompanyName;

    @ApiModelProperty(value = "更新人单位ID")
    @TableField("UPDATE_COMPANY_ID_")
    private String updateCompanyId;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getOutManifestNum() {
        return outManifestNum;
    }

    public void setOutManifestNum(String outManifestNum) {
        this.outManifestNum = outManifestNum;
    }
    public BigDecimal getAmount() {
        return amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
    public BigDecimal getTransactionServiceFee() {
        return transactionServiceFee;
    }

    public void setTransactionServiceFee(BigDecimal transactionServiceFee) {
        this.transactionServiceFee = transactionServiceFee;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getOutManifestUserId() {
        return outManifestUserId;
    }

    public void setOutManifestUserId(String outManifestUserId) {
        this.outManifestUserId = outManifestUserId;
    }
    public String getOutManifestUserName() {
        return outManifestUserName;
    }

    public void setOutManifestUserName(String outManifestUserName) {
        this.outManifestUserName = outManifestUserName;
    }
    public String getOutManifestUserPhone() {
        return outManifestUserPhone;
    }

    public void setOutManifestUserPhone(String outManifestUserPhone) {
        this.outManifestUserPhone = outManifestUserPhone;
    }
    public String getOutManifestCompanyId() {
        return outManifestCompanyId;
    }

    public void setOutManifestCompanyId(String outManifestCompanyId) {
        this.outManifestCompanyId = outManifestCompanyId;
    }
    public String getOutManifestCompanyName() {
        return outManifestCompanyName;
    }

    public void setOutManifestCompanyName(String outManifestCompanyName) {
        this.outManifestCompanyName = outManifestCompanyName;
    }
    public LocalDate getOutManifestDate() {
        return outManifestDate;
    }

    public void setOutManifestDate(LocalDate outManifestDate) {
        this.outManifestDate = outManifestDate;
    }
    public String getOutManifestAddress() {
        return outManifestAddress;
    }

    public void setOutManifestAddress(String outManifestAddress) {
        this.outManifestAddress = outManifestAddress;
    }
    public String getInManifestUserId() {
        return inManifestUserId;
    }

    public void setInManifestUserId(String inManifestUserId) {
        this.inManifestUserId = inManifestUserId;
    }
    public String getInManifestUserName() {
        return inManifestUserName;
    }

    public void setInManifestUserName(String inManifestUserName) {
        this.inManifestUserName = inManifestUserName;
    }
    public String getInManifestUserPhone() {
        return inManifestUserPhone;
    }

    public void setInManifestUserPhone(String inManifestUserPhone) {
        this.inManifestUserPhone = inManifestUserPhone;
    }
    public String getInManifestCompanyId() {
        return inManifestCompanyId;
    }

    public void setInManifestCompanyId(String inManifestCompanyId) {
        this.inManifestCompanyId = inManifestCompanyId;
    }
    public String getInManifestCompanyName() {
        return inManifestCompanyName;
    }

    public void setInManifestCompanyName(String inManifestCompanyName) {
        this.inManifestCompanyName = inManifestCompanyName;
    }
    public LocalDate getInManifestDate() {
        return inManifestDate;
    }

    public void setInManifestDate(LocalDate inManifestDate) {
        this.inManifestDate = inManifestDate;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public String getCreateCompanyId() {
        return createCompanyId;
    }

    public void setCreateCompanyId(String createCompanyId) {
        this.createCompanyId = createCompanyId;
    }
    public String getCreateCompanyName() {
        return createCompanyName;
    }

    public void setCreateCompanyName(String createCompanyName) {
        this.createCompanyName = createCompanyName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateCompanyName() {
        return updateCompanyName;
    }

    public void setUpdateCompanyName(String updateCompanyName) {
        this.updateCompanyName = updateCompanyName;
    }
    public String getUpdateCompanyId() {
        return updateCompanyId;
    }

    public void setUpdateCompanyId(String updateCompanyId) {
        this.updateCompanyId = updateCompanyId;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizOutManifest{" +
            "id=" + id +
            ", outManifestNum=" + outManifestNum +
            ", amount=" + amount +
            ", transactionServiceFee=" + transactionServiceFee +
            ", contractId=" + contractId +
            ", contractName=" + contractName +
            ", outManifestUserId=" + outManifestUserId +
            ", outManifestUserName=" + outManifestUserName +
            ", outManifestUserPhone=" + outManifestUserPhone +
            ", outManifestCompanyId=" + outManifestCompanyId +
            ", outManifestCompanyName=" + outManifestCompanyName +
            ", outManifestDate=" + outManifestDate +
            ", outManifestAddress=" + outManifestAddress +
            ", inManifestUserId=" + inManifestUserId +
            ", inManifestUserName=" + inManifestUserName +
            ", inManifestUserPhone=" + inManifestUserPhone +
            ", inManifestCompanyId=" + inManifestCompanyId +
            ", inManifestCompanyName=" + inManifestCompanyName +
            ", inManifestDate=" + inManifestDate +
            ", status=" + status +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createOrgName=" + createOrgName +
            ", createCompanyId=" + createCompanyId +
            ", createCompanyName=" + createCompanyName +
            ", createOrgId=" + createOrgId +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateCompanyName=" + updateCompanyName +
            ", updateCompanyId=" + updateCompanyId +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
