package com.artfess.cgpt.order.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Description:支付平台支付明细VO
 * @Author: Rong Tao
 * @Date: 2024/5/23 10:44
 */
@Data
public class OrderDetailsVo implements Serializable {

    @ApiModelProperty(value = "流水号（关联支付表订单号）")
    private String statementsCode;

    @ApiModelProperty(value = "用户ID")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    private String userAccount;

    @ApiModelProperty(value = "用户姓名")
    private String userName;

    @ApiModelProperty(value = "用户所属公司ID")
    private String companyId;

    @ApiModelProperty(value = "用户所属公司编号")
    private String companyCode;

    @ApiModelProperty(value = "用户所属公司名称")
    private String companyName;

    @ApiModelProperty(value = "销售方公司ID")
    private String salesCompanyId;

    @ApiModelProperty(value = "销售方公司编号")
    private String salesCompanyCode;

    @ApiModelProperty(value = "销售方公司名称")
    private String salesCompanyName;

    @ApiModelProperty(value = "物料编号")
    private String matCode;

    @ApiModelProperty(value = "费用名称（商品名称）")
    private String payName;

    @ApiModelProperty(value = "规格型号")
    private String specification;

    @ApiModelProperty(value = "费用类型（1：会员费，2：保证金，3：合同预付款，4：货款，5：标书费，" +
            "6：退还保证金，7：退款，8：提现，9：余额充值，10：交易服务费，" +
            "11：人工核对，12：没收保证金，13：预缴会员费，14：入围资格费，15：合同服务费，16：开票服务费）")
    private Integer payType;

    @ApiModelProperty(value = "单价")
    private BigDecimal price;

    @ApiModelProperty(value = "单位")
    private String unit;

    @ApiModelProperty(value = "数量（默认1）")
    private BigDecimal quantity;

    @ApiModelProperty(value = "订单金额（总计）")
    private BigDecimal rechargePrice;

    @ApiModelProperty(value = "含税标志（0：不含税 ，1：含税， 默认1）")
    private Integer isTax;

    @ApiModelProperty(value = "税率（小数）")
    private BigDecimal taxRate;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "备注")
    private String remarks;

    @ApiModelProperty(value = "发票状态，使用字典（1：未开票，2：开票中，3：已开票，4：不能开票）")
    private Integer invoiceStatus;

}
