package com.artfess.cgpt.order.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 用户报名订单物料明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizUserApplicationMatDetails对象", description="用户报名订单物料明细表")
public class BizUserApplicationMatDetails extends BaseModel<BizUserApplicationMatDetails> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "用户所属公司编码")
    @TableField("COMPANY_CODE_")
    private String companyCode;

    @ApiModelProperty(value = "联系方式")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "用户所属公司ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "报名时间")
    @TableField("APPLICATION_DATE_")
    private LocalDateTime applicationDate;

    @ApiModelProperty(value = "用户所属公司名称")
    @TableField("COMPANY_NAME_")
    private String companyName;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项标题")
    @TableField("NOTICE_TITLE_")
    private String noticeTitle;

    @ApiModelProperty(value = "立项编号")
    @TableField("NOTICE_NUMBER_")
    private String noticeNumber;

    @ApiModelProperty(value = "采购申请ID（关联采购申请表ID）")
    @TableField("PURCHASING_APPLICATION_ID_")
    private String purchasingApplicationId;

    @ApiModelProperty(value = "物料ID")
    @TableField("MAT_ID_")
    private String matId;

    @ApiModelProperty(value = "企业编号")
    @TableField("MAT_COMPANY_CODE_")
    private String matCompanyCode;

    @ApiModelProperty(value = "企业ID")
    @TableField("MAT_COMPANY_ID_")
    private String matCompanyId;

    @ApiModelProperty(value = "企业名称")
    @TableField("MAT_COMPANY_NAME_")
    private String matCompanyName;

    @ApiModelProperty(value = "平台物料号")
    @TableField("MAT_PLATCODE_")
    private String matPlatcode;

    @ApiModelProperty(value = "物料分类CODE，关联物料分类CODE")
    @TableField("MAT_CATEGORY_CODE_")
    private String matCategoryCode;

    @ApiModelProperty(value = "物料编码")
    @TableField("MAT_CODE_")
    private String matCode;

    @ApiModelProperty(value = "物料名称")
    @TableField("MAT_NAME_")
    private String matName;

    @ApiModelProperty(value = "物料牌号")
    @TableField("MAT_MATERIAL_")
    private String matMaterial;

    @ApiModelProperty(value = "规格型号")
    @TableField("MAT_SPEC_")
    private String matSpec;

    @ApiModelProperty(value = "数量")
    @TableField("MAT_NUM_")
    private BigDecimal matNum;

    @ApiModelProperty(value = "计量单位")
    @TableField("MAT_UNIT_")
    private String matUnit;

    @ApiModelProperty(value = "采购方式（使用字典，1：平台招标，2：企业招标，3：企业线下定价）")
    @TableField("PROCUREMENT_METHOD_")
    private String procurementMethod;

    @ApiModelProperty(value = "招标方式（使用字典，1：招标采购:2：邀请招标采购:3：竞争性谈判:4：竞价采购:5：询价采购:6：单一来源采购:7：多源采购）")
    @TableField("APPLICATION_METHOD_")
    private String applicationMethod;

    @ApiModelProperty(value = "需求日期")
    @TableField("DEMAND_DATE")
    private LocalDate demandDate;

    @ApiModelProperty(value = "有无资质要求（0：无，1：有）")
    @TableField("HAS_QUALIFICATION_")
    private String hasQualification;

    @ApiModelProperty(value = "报名状态（使用字典，1：审核中，2：审核已通过，3：审核未通过，4：已报名，5：已取消））")
    @TableField("STATUS_")
    private Integer status;

    @ApiModelProperty(value = "计划价格")
    @TableField("PLANNED_PRICE_")
    private BigDecimal plannedPrice;

    @ApiModelProperty(value = "品牌")
    @TableField("MAT_BRAND_")
    private String matBrand;

    @ApiModelProperty(value = "基础扩展")
    @TableField("MAT_BASE_EXT_")
    private String matBaseExt;

    @ApiModelProperty(value = "其他扩展")
    @TableField("MAT_OTHER_EXT_")
    private String matOtherExt;

    @ApiModelProperty(value = "备注")
    @TableField("REMARKS_")
    private String remarks;

    @ApiModelProperty(value = "排序号")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "是否已删，1：已删除，0：未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "创建人ID")
    @TableField("CREATE_BY_")
    private String createBy;

    @ApiModelProperty(value = "创建人姓名")
    @TableField("CREATE_NAME_")
    private String createName;

    @ApiModelProperty(value = "创建人部门ID")
    @TableField("CREATE_DEPT_ID_")
    private String createDeptId;

    @ApiModelProperty(value = "创建人部门名称")
    @TableField("CREATE_DEPT_NAME_")
    private String createDeptName;

    @ApiModelProperty(value = "创建人组织ID")
    @TableField("CREATE_ORG_ID_")
    private String createOrgId;

    @ApiModelProperty(value = "创建人组织名称")
    @TableField("CREATE_ORG_NAME_")
    private String createOrgName;

    @ApiModelProperty(value = "创建时间")
    @TableField("CREATE_TIME_")
    private LocalDateTime createTime;

    @ApiModelProperty(value = "更新人ID")
    @TableField("UPDATE_BY_")
    private String updateBy;

    @ApiModelProperty(value = "更新人姓名")
    @TableField("UPDATE_NAME_")
    private String updateName;

    @ApiModelProperty(value = "更新人部门ID")
    @TableField("UPDATE_DEPT_ID_")
    private String updateDeptId;

    @ApiModelProperty(value = "更新人部门名称")
    @TableField("UPDATE_DEPT_NAME_")
    private String updateDeptName;

    @ApiModelProperty(value = "更新人组织ID")
    @TableField("UPDATE_ORG_ID_")
    private String updateOrgId;

    @ApiModelProperty(value = "更新人组织名称")
    @TableField("UPDATE_ORG_NAME_")
    private String updateOrgName;

    @ApiModelProperty(value = "更新时间")
    @TableField("UPDATE_TIME_")
    private LocalDateTime updateTime;

    @ApiModelProperty(value = "最后更新时间戳")
    @TableField("LAST_TIME_")
    private Long lastTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Long version;

    @ApiModelProperty(value = "租户ID")
    @TableField("TENANT_ID_")
    private String tenantId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }
    public String getUserAccount() {
        return userAccount;
    }

    public void setUserAccount(String userAccount) {
        this.userAccount = userAccount;
    }
    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
    public String getCompanyCode() {
        return companyCode;
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }
    public String getUserPhone() {
        return userPhone;
    }

    public void setUserPhone(String userPhone) {
        this.userPhone = userPhone;
    }
    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }
    public LocalDateTime getApplicationDate() {
        return applicationDate;
    }

    public void setApplicationDate(LocalDateTime applicationDate) {
        this.applicationDate = applicationDate;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public String getNoticeId() {
        return noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }
    public String getNoticeTitle() {
        return noticeTitle;
    }

    public void setNoticeTitle(String noticeTitle) {
        this.noticeTitle = noticeTitle;
    }
    public String getNoticeNumber() {
        return noticeNumber;
    }

    public void setNoticeNumber(String noticeNumber) {
        this.noticeNumber = noticeNumber;
    }
    public String getPurchasingApplicationId() {
        return purchasingApplicationId;
    }

    public void setPurchasingApplicationId(String purchasingApplicationId) {
        this.purchasingApplicationId = purchasingApplicationId;
    }
    public String getMatId() {
        return matId;
    }

    public void setMatId(String matId) {
        this.matId = matId;
    }
    public String getMatCompanyCode() {
        return matCompanyCode;
    }

    public void setMatCompanyCode(String matCompanyCode) {
        this.matCompanyCode = matCompanyCode;
    }
    public String getMatCompanyId() {
        return matCompanyId;
    }

    public void setMatCompanyId(String matCompanyId) {
        this.matCompanyId = matCompanyId;
    }
    public String getMatCompanyName() {
        return matCompanyName;
    }

    public void setMatCompanyName(String matCompanyName) {
        this.matCompanyName = matCompanyName;
    }
    public String getMatPlatcode() {
        return matPlatcode;
    }

    public void setMatPlatcode(String matPlatcode) {
        this.matPlatcode = matPlatcode;
    }
    public String getMatCategoryCode() {
        return matCategoryCode;
    }

    public void setMatCategoryCode(String matCategoryCode) {
        this.matCategoryCode = matCategoryCode;
    }
    public String getMatCode() {
        return matCode;
    }

    public void setMatCode(String matCode) {
        this.matCode = matCode;
    }
    public String getMatName() {
        return matName;
    }

    public void setMatName(String matName) {
        this.matName = matName;
    }
    public String getMatMaterial() {
        return matMaterial;
    }

    public void setMatMaterial(String matMaterial) {
        this.matMaterial = matMaterial;
    }
    public String getMatSpec() {
        return matSpec;
    }

    public void setMatSpec(String matSpec) {
        this.matSpec = matSpec;
    }
    public BigDecimal getMatNum() {
        return matNum;
    }

    public void setMatNum(BigDecimal matNum) {
        this.matNum = matNum;
    }
    public String getMatUnit() {
        return matUnit;
    }

    public void setMatUnit(String matUnit) {
        this.matUnit = matUnit;
    }
    public String getProcurementMethod() {
        return procurementMethod;
    }

    public void setProcurementMethod(String procurementMethod) {
        this.procurementMethod = procurementMethod;
    }
    public String getApplicationMethod() {
        return applicationMethod;
    }

    public void setApplicationMethod(String applicationMethod) {
        this.applicationMethod = applicationMethod;
    }
    public LocalDate getDemandDate() {
        return demandDate;
    }

    public void setDemandDate(LocalDate demandDate) {
        this.demandDate = demandDate;
    }
    public String getHasQualification() {
        return hasQualification;
    }

    public void setHasQualification(String hasQualification) {
        this.hasQualification = hasQualification;
    }
    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }
    public BigDecimal getPlannedPrice() {
        return plannedPrice;
    }

    public void setPlannedPrice(BigDecimal plannedPrice) {
        this.plannedPrice = plannedPrice;
    }
    public String getMatBrand() {
        return matBrand;
    }

    public void setMatBrand(String matBrand) {
        this.matBrand = matBrand;
    }
    public String getMatBaseExt() {
        return matBaseExt;
    }

    public void setMatBaseExt(String matBaseExt) {
        this.matBaseExt = matBaseExt;
    }
    public String getMatOtherExt() {
        return matOtherExt;
    }

    public void setMatOtherExt(String matOtherExt) {
        this.matOtherExt = matOtherExt;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    public Integer getSn() {
        return sn;
    }

    public void setSn(Integer sn) {
        this.sn = sn;
    }
    public String getIsDele() {
        return isDele;
    }

    public void setIsDele(String isDele) {
        this.isDele = isDele;
    }
    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }
    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }
    public String getCreateDeptId() {
        return createDeptId;
    }

    public void setCreateDeptId(String createDeptId) {
        this.createDeptId = createDeptId;
    }
    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }
    public String getCreateOrgId() {
        return createOrgId;
    }

    public void setCreateOrgId(String createOrgId) {
        this.createOrgId = createOrgId;
    }
    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }
    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }
    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }
    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }
    public String getUpdateDeptId() {
        return updateDeptId;
    }

    public void setUpdateDeptId(String updateDeptId) {
        this.updateDeptId = updateDeptId;
    }
    public String getUpdateDeptName() {
        return updateDeptName;
    }

    public void setUpdateDeptName(String updateDeptName) {
        this.updateDeptName = updateDeptName;
    }
    public String getUpdateOrgId() {
        return updateOrgId;
    }

    public void setUpdateOrgId(String updateOrgId) {
        this.updateOrgId = updateOrgId;
    }
    public String getUpdateOrgName() {
        return updateOrgName;
    }

    public void setUpdateOrgName(String updateOrgName) {
        this.updateOrgName = updateOrgName;
    }
    public LocalDateTime getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(LocalDateTime updateTime) {
        this.updateTime = updateTime;
    }
    public Long getLastTime() {
        return lastTime;
    }

    public void setLastTime(Long lastTime) {
        this.lastTime = lastTime;
    }
    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }
    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "BizUserApplicationMatDetails{" +
            "id=" + id +
            ", userId=" + userId +
            ", userAccount=" + userAccount +
            ", userName=" + userName +
            ", companyCode=" + companyCode +
            ", userPhone=" + userPhone +
            ", companyId=" + companyId +
            ", applicationDate=" + applicationDate +
            ", companyName=" + companyName +
            ", noticeId=" + noticeId +
            ", noticeTitle=" + noticeTitle +
            ", noticeNumber=" + noticeNumber +
            ", purchasingApplicationId=" + purchasingApplicationId +
            ", matId=" + matId +
            ", matCompanyCode=" + matCompanyCode +
            ", matCompanyId=" + matCompanyId +
            ", matCompanyName=" + matCompanyName +
            ", matPlatcode=" + matPlatcode +
            ", matCategoryCode=" + matCategoryCode +
            ", matCode=" + matCode +
            ", matName=" + matName +
            ", matMaterial=" + matMaterial +
            ", matSpec=" + matSpec +
            ", matNum=" + matNum +
            ", matUnit=" + matUnit +
            ", procurementMethod=" + procurementMethod +
            ", applicationMethod=" + applicationMethod +
            ", demandDate=" + demandDate +
            ", hasQualification=" + hasQualification +
            ", status=" + status +
            ", plannedPrice=" + plannedPrice +
            ", matBrand=" + matBrand +
            ", matBaseExt=" + matBaseExt +
            ", matOtherExt=" + matOtherExt +
            ", remarks=" + remarks +
            ", sn=" + sn +
            ", isDele=" + isDele +
            ", createBy=" + createBy +
            ", createName=" + createName +
            ", createDeptId=" + createDeptId +
            ", createDeptName=" + createDeptName +
            ", createOrgId=" + createOrgId +
            ", createOrgName=" + createOrgName +
            ", createTime=" + createTime +
            ", updateBy=" + updateBy +
            ", updateName=" + updateName +
            ", updateDeptId=" + updateDeptId +
            ", updateDeptName=" + updateDeptName +
            ", updateOrgId=" + updateOrgId +
            ", updateOrgName=" + updateOrgName +
            ", updateTime=" + updateTime +
            ", lastTime=" + lastTime +
            ", version=" + version +
            ", tenantId=" + tenantId +
        "}";
    }
}
