package com.artfess.cgpt.order.model;

import com.artfess.base.entity.BizModel;
import com.artfess.cgpt.universal.model.Accessory;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@ApiModel(value="BizRegistrationOrder对象", description="订单表")
@Data
@TableName("biz_registration_order")
public class BizRegistrationOrder extends BizModel<BizRegistrationOrder> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "参与表ID")
    @TableField("PARTICIPATION_ID")
    private String participationId;

    @ApiModelProperty(value = "订单号")
    @TableField("ORDER_NUMBER_")
    private String orderNumber;

    @ApiModelProperty(value = "支付状态（1：未支付，2：支付中，3：已支付），默认1")
    @TableField("PAY_STATUS_")
    private Integer payStatus;

    @ApiModelProperty(value = "退款状态（1：未退款，2：退款中，3：已退款），默认1")
    @TableField("REFUND_STATUS_")
    private Integer refundStatus;

    @ApiModelProperty(value = "退款单号（关联订单表ID）")
    @TableField("REFUND_ORDER_ID_")
    private String refundOrderId;

    @ApiModelProperty(value = "立项ID")
    @TableField("NOTICE_ID_")
    private String noticeId;

    @ApiModelProperty(value = "立项类型（1：物料，2：项目）")
    @TableField("NOTICE_TYPE_")
    private Integer noticeType;

    @ApiModelProperty(value = "用户ID")
    @TableField("USER_ID_")
    private String userId;

    @ApiModelProperty(value = "用户账号")
    @TableField("USER_ACCOUNT_")
    private String userAccount;

    @ApiModelProperty(value = "用户姓名")
    @TableField("USER_NAME_")
    private String userName;

    @ApiModelProperty(value = "联系方式")
    @TableField("USER_PHONE_")
    private String userPhone;

    @ApiModelProperty(value = "费用类型（2：保证金，4：货款，5：标书费，6：退还保证金）")
    @TableField("PAY_TYPE_")
    private Integer payType;

    @ApiModelProperty(value = "支付单位ID")
    @TableField("PAY_UNIT_ID_")
    private String payUnitId;

    @ApiModelProperty(value = "支付单位编号")
    @TableField("PAY_UNIT_CODE_")
    private String payUnitCode;

    @ApiModelProperty(value = "支付单位名称")
    @TableField("PAY_UNIT_NAME_")
    private String payUnitName;

    @ApiModelProperty(value = "支付账号")
    @TableField("PAY_ACCOUNT_")
    private String payAccount;

    @ApiModelProperty(value = "支付账号开户行")
    @TableField("PAY_ACCOUNT_BANK_")
    private String payAccountBank;

    @ApiModelProperty(value = "支付时间")
    @TableField("PAY_TIME_")
    private LocalDateTime payTime;

    @ApiModelProperty(value = "支付时间戳")
    @TableField("PAY_TIMER_")
    private Long payTimer;

    @ApiModelProperty(value = "支付金额")
    @TableField("PAY_AMOUNT_")
    private BigDecimal payAmount;

    @ApiModelProperty(value = "收款单位ID")
    @TableField("COLLECT_UNIT_ID_")
    private String collectUnitId;

    @ApiModelProperty(value = "收款单位编号")
    @TableField("COLLECT_UNIT_CODE_")
    private String collectUnitCode;

    @ApiModelProperty(value = "收款单位名称")
    @TableField("COLLECT_UNIT_NAME_")
    private String collectUnitName;

    @ApiModelProperty(value = "收款账号")
    @TableField("COLLECT_ACCOUNT_")
    private String collectAccount;

    @ApiModelProperty(value = "收款账号开户行")
    @TableField("COLLECT_ACCOUNT_BANK_")
    private String collectAccountBank;

    @ApiModelProperty(value = "收款到账时间")
    @TableField("COLLECT_TIME_")
    private LocalDateTime collectTime;

    @ApiModelProperty(value = "收款到账时间戳")
    @TableField("COLLECT_TIMER_")
    private Long collectTimer;

    @ApiModelProperty(value = "支付描述")
    @TableField("PAY_DESCRIBE_")
    private String payDescribe;

    @ApiModelProperty(value = "订单明细")
    @TableField(exist = false)
    private List<BizRegistrationOrderDetails> detailsList;

}
