package com.artfess.cgpt.order.manager.impl;

import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cgpt.order.model.BizRegistrationOrder;
import com.artfess.cgpt.order.model.BizRegistrationOrderDetails;
import com.artfess.cgpt.order.dao.BizRegistrationOrderDetailsDao;
import com.artfess.cgpt.order.manager.BizRegistrationOrderDetailsManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.utils.BizUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 订单交易明细表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2024-01-17
 */
@Service
public class BizRegistrationOrderDetailsManagerImpl extends BaseManagerImpl<BizRegistrationOrderDetailsDao, BizRegistrationOrderDetails> implements BizRegistrationOrderDetailsManager {
    @Autowired
    private UCFeignService ucFeignService;
    @Override
    public PageList<BizRegistrationOrderDetails> queryAllByPage(QueryFilter<BizRegistrationOrderDetails> queryFilter) {


        BizUtils.addFilterByOrgCodeAndRole(queryFilter,ucFeignService,"MAT_COMPANY_ID_");

        IPage<BizRegistrationOrderDetails> materialIPage = baseMapper.queryAllByPage
                (convert2IPage(queryFilter.getPageBean()), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(materialIPage);
    }

    @Override
    public List<BizRegistrationOrderDetails> getListByOrderId(String orderId) {

        QueryWrapper<BizRegistrationOrderDetails> wrapper = new QueryWrapper<>();
        wrapper.eq("REGISTRATION_ORDER_ID_",orderId);
        List<BizRegistrationOrderDetails> details = baseMapper.selectList(wrapper);

        return details;
    }
}
