package com.artfess.cgpt.material.manager.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.nacos.client.config.utils.ContentUtils;
import com.artfess.base.exception.BaseException;
import com.artfess.base.feign.UCFeignService;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cgpt.foreignApi.service.ForeignCallService;
import com.artfess.cgpt.foreignApi.vo.Response;
import com.artfess.cgpt.material.manager.BizMaterialManager;
import com.artfess.cgpt.material.manager.PlatMaterialManager;
import com.artfess.cgpt.material.model.BizMaterial;
import com.artfess.cgpt.material.model.BizMaterialCategory;
import com.artfess.cgpt.material.dao.BizMaterialCategoryDao;
import com.artfess.cgpt.material.manager.BizMaterialCategoryManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cgpt.material.model.PlatMaterial;
import com.artfess.cgpt.material.vo.MatCategoryVo;
import com.artfess.cgpt.utils.BizUtil;
import com.artfess.cgpt.utils.BizUtils;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import javafx.scene.paint.Material;
import org.apache.poi.ss.usermodel.Workbook;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;
import java.util.stream.Collectors;

/**
 *  服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-12-22
 */
@Service
public class BizMaterialCategoryManagerImpl extends BaseManagerImpl<BizMaterialCategoryDao, BizMaterialCategory> implements BizMaterialCategoryManager {

    @Value("${zsj.getEnterpriseCategotyUrl}")
    private String zsjGetEnterpriseCategotyUrl;

    @Autowired
    UCFeignService ucFeignService;
    @Autowired
    private BizMaterialManager materialManager;
    @Autowired
    private ForeignCallService foreignCallService;
    @Autowired
    private PlatMaterialManager platMaterialManager;

    @Override
    public List<BizMaterialCategory> selectTree() {
        LambdaQueryWrapper<BizMaterialCategory> allQW = new LambdaQueryWrapper<>();
        allQW.eq(BizMaterialCategory::getIsDele,"0")
                .orderByAsc(BizMaterialCategory::getCode);
        List<BizMaterialCategory> categories = super.list(allQW);
        if(BeanUtils.isEmpty(categories) || categories.size()<=0){
            return new ArrayList<>();
        }
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
//        List<BizMaterialCategory> collect = categories.stream().filter(BizMaterialCategory -> BeanUtils.isEmpty(BizMaterialCategory.getParentCode())).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public PageList<BizMaterialCategory> queryAllByPage(QueryFilter<BizMaterialCategory> queryFilter) {
        queryFilter.addFilter("IS_DELE_","0", QueryOP.EQUAL);
        IPage<BizMaterialCategory> result = baseMapper.queryAllByPage(convert2IPage(queryFilter.getPageBean()),
                convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

    @Override
    public List<BizMaterialCategory> getEnterpriseCategoryTree() {
        List<String> codeList = new ArrayList<>();
        if(BizUtils.isAdmin(ucFeignService)){
            //1.查询主数据企业所授权的物料分类编码
            try {
                JSONObject param = new JSONObject();
                param.set("companyCode",ContextUtil.getCurrentGroup().getGroupCode());
                JSONObject codeListObj = foreignCallService.callInterfaceResponse(zsjGetEnterpriseCategotyUrl, param, 1);
                if(codeListObj.get("code").equals("0")){
                    if(BeanUtils.isNotEmpty(codeListObj.get("data"))){
                        codeList.addAll(JSONUtil.toList(codeListObj.getJSONArray("data"),String.class));
                    }
                }else {
                    if(BeanUtils.isNotEmpty(codeListObj.get("msg"))){
                        throw new BaseException(codeListObj.getStr("msg"));
                    }else {
                        throw new BaseException(codeListObj.toString());
                    }
                }

            } catch (Exception e){
                e.printStackTrace();
                System.out.println("查询主数据企业授权分类失败："+e.getMessage());
                return new ArrayList<>();
            }
        }

        LambdaQueryWrapper<BizMaterialCategory> allQW = new LambdaQueryWrapper<>();
        allQW.eq(BizMaterialCategory::getIsDele,"0")
                .orderByAsc(BizMaterialCategory::getCode);;
        //2.根据编码查询物料分类
        if(codeList.size()>0){
            allQW.in(BizMaterialCategory::getCode,codeList);
        }
        List<BizMaterialCategory> categories = super.list(allQW);

        if(BeanUtils.isEmpty(categories) || categories.size()<=0){
            return new ArrayList<>();
        }

        //3.组装树形结构
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
//        List<BizMaterialCategory> collect = categories.stream().filter(BizMaterialCategory -> BeanUtils.isEmpty(BizMaterialCategory.getParentCode())).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public List<BizMaterialCategory> getEnterpriseCategoryTree(String companyCode) {
        List<String> codeList = new ArrayList<>();
        //1.查询主数据企业所授权的物料分类编码
        try {
            JSONObject param = new JSONObject();
            param.set("companyCode",companyCode);
            JSONObject codeListObj = foreignCallService.callInterfaceResponse(zsjGetEnterpriseCategotyUrl, param, 1);
            if(codeListObj.get("code").equals("0")){
                if(BeanUtils.isNotEmpty(codeListObj.get("data"))){
                    codeList.addAll(JSONUtil.toList(codeListObj.getJSONArray("data"),String.class));
                }
            }else {
                if(BeanUtils.isNotEmpty(codeListObj.get("msg"))){
                    throw new BaseException(codeListObj.getStr("msg"));
                }else {
                    throw new BaseException(codeListObj.toString());
                }
            }
        } catch (Exception e){
            e.printStackTrace();
            System.out.println("查询主数据企业授权分类失败："+e.getMessage());
            return new ArrayList<>();
        }

        if(codeList.size()<=0){
            return new ArrayList<>();
        }

        //2.根据编码查询物料分类
        LambdaQueryWrapper<BizMaterialCategory> allQW = new LambdaQueryWrapper<>();
        allQW.eq(BizMaterialCategory::getIsDele,"0")
                .in(BizMaterialCategory::getCode,codeList);
        List<BizMaterialCategory> categories = super.list(allQW);

        if(BeanUtils.isEmpty(categories) || categories.size()<=0){
            return new ArrayList<>();
        }
        //3.组装树形结构
        List<BizMaterialCategory> collect = categories.stream().filter(category -> category.getParentId().equals("0")).collect(Collectors.toList());
//        List<BizMaterialCategory> collect = categories.stream().filter(BizMaterialCategory -> BeanUtils.isEmpty(BizMaterialCategory.getParentCode())).collect(Collectors.toList());
        for (BizMaterialCategory c : collect) {
            c.setChildren(getchildren(c, categories));
        }
        return collect;
    }

    @Override
    public void exportExcelData(QueryFilter<BizMaterialCategory> queryFilter, HttpServletResponse response) throws IOException {
        String fileName = "物料分类-导出数据";
//        queryFilter.setPageBean(new PageBean(0, -1, false));
        List<BizMaterialCategory> data = queryAllByPage(queryFilter).getRows();
        if (null == data || data.size() == 0) {
            throw new RuntimeException("没有要导出的的数据！");
        }

        // EasyPoi 导出参数、样式、表格格式设置
        ExportParams exportParams = BizUtil.getExportParams(fileName);
        fileName += ".xlsx";
        // 导出下载excel文件
        Workbook workbook = ExcelExportUtil.exportExcel(exportParams, BizMaterialCategory.class, data);
        ExcelUtil.downloadExcel(workbook, fileName, response);
    }

    @Override
    @Transactional
    public void updateYqcCategory(BizMaterialCategory entity) {
        super.updateById(entity);

        if(BeanUtils.isNotEmpty(entity.getYqcCategoryCode())){
            //更新子分类渝企采编码
            LambdaUpdateWrapper<BizMaterialCategory> childrenCateUW = new LambdaUpdateWrapper<>();
            childrenCateUW.set(BizMaterialCategory::getYqcCategoryCode,entity.getYqcCategoryCode())
                    .set(BizMaterialCategory::getYqcCategoryName,entity.getYqcCategoryName())
                    .likeRight(BizMaterialCategory::getCode,entity.getCode())
                    .eq(BizMaterialCategory::getIsDele,"0");
            super.update(childrenCateUW);
        }

    }

    @Override
    @Transactional
    public void saveOrUpdateEntity(BizMaterialCategory entity) {
        if(BeanUtils.isEmpty(entity.getId())) {
            LambdaQueryWrapper<BizMaterialCategory> hisQW = new LambdaQueryWrapper<>();
            hisQW.eq(BizMaterialCategory::getCode, entity.getCode())
                    .eq(BizMaterialCategory::getIsDele,"0");
            int count = super.count(hisQW);
            if (count > 0) {
                throw new BaseException("【"+entity.getCode()+"】编号已存在，请重新输入");
            }

            super.save(entity);
            LambdaUpdateWrapper<BizMaterialCategory> childrenUW =new LambdaUpdateWrapper<>();
            childrenUW.set(BizMaterialCategory::getHasChildren,1)
                    .eq(BizMaterialCategory::getId,entity.getParentId());
            super.update(childrenUW);

        }else {

            super.updateById(entity);
            if(BeanUtils.isNotEmpty(entity.getYqcCategoryCode())){
                //更新子分类渝企采编码
                LambdaUpdateWrapper<BizMaterialCategory> childrenCateUW = new LambdaUpdateWrapper<>();
                childrenCateUW.set(BizMaterialCategory::getYqcCategoryCode,entity.getYqcCategoryCode())
                        .set(BizMaterialCategory::getYqcCategoryName,entity.getYqcCategoryName())
                        .likeRight(BizMaterialCategory::getCode,entity.getCode())
                        .eq(BizMaterialCategory::getIsDele,"0");
                super.update(childrenCateUW);
            }

        }

    }

    @Override
    @Transactional
    public Response saveOrUpdateByApi(JSONObject param) {
        String code = "0";
        String message = "操作成功";
        String errDetail = "";
        try {
            LambdaQueryWrapper<BizMaterialCategory> catQW = new LambdaQueryWrapper<>();
            List<MatCategoryVo> paramList = JSONUtil.toList(param.getJSONArray("data"), MatCategoryVo.class);
            int count = 0;
            List<MatCategoryVo> newCate = new ArrayList<>();
            List<MatCategoryVo> data = paramList.stream().sorted(new Comparator<MatCategoryVo>() {
                @Override
                public int compare(MatCategoryVo o1, MatCategoryVo o2) {
                    return o1.getCatNo().length()-o2.getCatNo().length();
                }
            }).collect(Collectors.toList());

//            LambdaQueryWrapper<BizMaterialCategory> allQW = new LambdaQueryWrapper<>();
//            allQW.eq(BizMaterialCategory::getIsDele,"0");
//            List<BizMaterialCategory> ncateList = super.list(allQW);

            //根据分类编号新增
            for (MatCategoryVo temp : data) {
                catQW.eq(BizMaterialCategory::getCode, temp.getCatNo())
                        .eq(BizMaterialCategory::getIsDele, "0");
                //寻找分类是否存在
                count = super.count(catQW);
                if (0 == count) {
                    newCate.add(temp);
                } else {
                    LambdaUpdateWrapper<BizMaterialCategory> uw = new LambdaUpdateWrapper<>();
                    uw.set(BizMaterialCategory::getName, temp.getCatName())
                            .set(BizMaterialCategory::getStatus, temp.getStatus())
                            .eq(BizMaterialCategory::getCode, temp.getCatNo())
                            .eq(BizMaterialCategory::getIsDele, "0");
                    super.update(uw);
                }
                catQW.clear();
            }

            if(newCate.size()>0){
                for(MatCategoryVo temp : newCate){
                    BizMaterialCategory category = new BizMaterialCategory();
                    //寻找父节点是否存在
                    catQW.select(BizMaterialCategory::getId)
                            .eq(BizMaterialCategory::getCode, temp.getCatNo().subSequence(0, temp.getCatNo().length() - 2))
                            .eq(BizMaterialCategory::getIsDele,"0");
                    BizMaterialCategory fcat = baseMapper.selectOne(catQW);
                    if (BeanUtils.isNotEmpty(fcat)) {
                        category.setParentId(fcat.getId());
                    } else {
                        category.setParentId("0");
                    }
                    if(BeanUtils.isNotEmpty(temp.getCatFno())){
                        category.setParentCode(temp.getCatFno());
                    }
                    category.setCode(temp.getCatNo());
                    category.setName(temp.getCatName());
                    if(BeanUtils.isNotEmpty(temp.getStatus())){
                        category.setStatus(temp.getStatus());
                    }else {
                        category.setStatus(1);
                    }
                    super.save(category);
                    catQW.clear();
                }
            }

        }catch (Exception e){
            e.printStackTrace();
            code = "500";
            errDetail = e.getMessage();
            message = "操作失败:"+errDetail;
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }

        return new Response<>(code, message, errDetail);

    }

    @Override
    @Transactional
    public void updateStatus(List<String> ids, String status) {
        //状态（0：禁用，1：启用）
        if(status.equals("0")){
            //如果是禁用
            List<BizMaterialCategory> categoryList = super.listByIds(ids);
            for(BizMaterialCategory category : categoryList){
                //1.查询物料库是否有该物料分类编号的数据
                //如果有，不能禁用
                LambdaQueryWrapper<PlatMaterial> platMaterialQW = new LambdaQueryWrapper<>();
                platMaterialQW.eq(PlatMaterial::getMatCategory,category.getCode())
//                        .eq(PlatMaterial::getMatStatus,1)
                        .eq(PlatMaterial::getIsDele,"0");
                if(platMaterialManager.count(platMaterialQW)>0){
                    throw new BaseException("分类编号【"+category.getCode()+"】下存在平台物料，无法禁用");
                }


                LambdaQueryWrapper<BizMaterial> materialQW = new LambdaQueryWrapper<>();
                materialQW.eq(BizMaterial::getMatCategory,category.getCode())
//                        .eq(BizMaterial::getMatStatus,1)
                        .eq(BizMaterial::getIsDele,"0");
                if(materialManager.count(materialQW)>0){
                    throw new BaseException("分类编号【"+category.getCode()+"】下存在企业物料，无法禁用");
                }
            }

        }
        //2.修改分类启用状态
        LambdaUpdateWrapper<BizMaterialCategory> updateWrapper=new LambdaUpdateWrapper<>();
        updateWrapper.set(BizMaterialCategory::getStatus,status)
                .in(BizMaterialCategory::getId,ids)
                .eq(BizMaterialCategory::getIsDele,"0");
        super.update(updateWrapper);

    }

    private List<BizMaterialCategory> getchildren(BizMaterialCategory root, List<BizMaterialCategory> list) {
        List<BizMaterialCategory> children = list.stream().filter(category -> category.getParentId().equals(root.getId())
        ).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(children) && children.size() > 0) {
            for (BizMaterialCategory c : children) {
                c.setChildren(getchildren(c, list));
            }
        }
        return children;
    }
}
